uniform sampler3D intensityTexture;
uniform sampler3D gradientTexture;
uniform sampler1D transferTexture;
uniform sampler2D frontTexture;
uniform sampler2D backTexture;
uniform int renderUVs;
uniform float step;
uniform int phongExp;
uniform int renderTyp;
uniform float isoValue;

float intensityLookup () {
   vec3 texCoord = vec3(gl_TexCoord[0]);
   
   float v;
   v = vec4(texture3D(intensityTexture, texCoord + vec3(0.5, 0.5, 0.0)*0.001 )).x;
   v += vec4(texture3D(intensityTexture, texCoord + vec3(0.5, -0.5, 0.0)*0.001 )).x;
   v += vec4(texture3D(intensityTexture, texCoord + vec3(-0.5, 0.5, 0.0)*0.001 )).x;
   v += vec4(texture3D(intensityTexture, texCoord + vec3(-0.5, -0.5, 0.0)*0.001 )).x;
   
   return v*0.25;
}

vec4 getColorValue (vec4 density) {
   vec3 v         = vec3( vec4(density.x-0.5, -density.y+0.5, -density.z+0.5, 1.0));
   vec3 lightvec  = normalize( gl_LightSource[0].position.xyz - v);
   vec3 Eye       = normalize(-v);
   vec4 clr       = texture1D(transferTexture, density.w );
 
   vec3 gradient  = vec3(texture3D(gradientTexture, vec3(density.x, density.y, density.z)));  
   vec3 Reflected = normalize( reflect( -lightvec, gradient )); 
 
   vec4 IAmbient  = gl_LightSource[0].ambient * clr;
   vec4 IDiffuse  = gl_LightSource[0].diffuse  * clr * max(dot(gradient, lightvec), 0.0);
   vec4 ISpecular = gl_LightSource[0].specular * clr * pow(max(dot(Reflected, Eye), 0.0), phongExp);
 
  // vec4 tmp = vec4(gl_LightSource[0].position.x, gl_LightSource[0].position.y, gl_LightSource[0].position.z, 0.0);
   return IAmbient + IDiffuse + ISpecular; 
}

vec4 ray_casting_iso () {
// ray casting of iso surfaces

	vec4 Eintritt, Austritt, clr;
	float dx, dy, dz, x, y, z, xe, ye, tex, ze;
	vec4 maxValue;
	
	Eintritt = vec4( texture2D( frontTexture, vec2(gl_TexCoord[0].x, 1-gl_TexCoord[0].y) ) );
	Austritt = vec4( texture2D( backTexture, vec2(gl_TexCoord[0].x, 1-gl_TexCoord[0].y) ) );
	
	if (Eintritt.xyz != Austritt.xyz) {
		// cast a ray
		
		dx = (Austritt.x - Eintritt.x) / step;
		dy = (Austritt.y - Eintritt.y) / step;
		dz = (Austritt.z - Eintritt.z) / step;
		
		x = Eintritt.x;
		y = Eintritt.y;
		z = Eintritt.z;
		maxValue.w = 0.0;
		   
		while( ((( Eintritt.x <= Austritt.x) && x <= Austritt.x) || (( Eintritt.x > Austritt.x) && x >= Austritt.x)) && 
			   ((( Eintritt.y <= Austritt.y) && y <= Austritt.y) || (( Eintritt.y > Austritt.y) && y >= Austritt.y)) &&
		       ((( Eintritt.z <= Austritt.z) && z <= Austritt.z) || (( Eintritt.z > Austritt.z) && z >= Austritt.z)) ) {
		    
		    tex = vec4(texture3D(intensityTexture, vec3(x, y, z))).x;
		    
		    if ( tex > isoValue) {
		       maxValue.w = tex;
		       maxValue.x = x;
		       maxValue.y = y;
		       maxValue.z = z;
		      
		       break;		       
		    }
		    x += dx;
		    y += dy;
		    z += dz;
		}
	
		clr = getColorValue(maxValue);
	} else {
	    // draw background
	    clr = vec4(0.0, 0.0, 0.0, 0.0);   
	}
	
	return clr;
}


vec4 ray_casting_max () {
// ray casting with maximum intensity

	vec4 Eintritt, Austritt, clr;
	float dx, dy, dz, x, y, z, xe, ye, tex, ze;
	vec4 maxValue;
	
	Eintritt = vec4( texture2D( frontTexture, vec2(gl_TexCoord[0].x, 1-gl_TexCoord[0].y) ) );
	Austritt = vec4( texture2D( backTexture, vec2(gl_TexCoord[0].x, 1-gl_TexCoord[0].y) ) );
	
	if (Eintritt.xyz != Austritt.xyz) {
		// cast a ray
		
		dx = (Austritt.x - Eintritt.x) / step;
		dy = (Austritt.y - Eintritt.y) / step;
		dz = (Austritt.z - Eintritt.z) / step;
		
		x = Eintritt.x;
		y = Eintritt.y;
		z = Eintritt.z;
		maxValue.w = 0.0;
		   
		while( ((( Eintritt.x <= Austritt.x) && x <= Austritt.x) || (( Eintritt.x > Austritt.x) && x >= Austritt.x)) && 
			   ((( Eintritt.y <= Austritt.y) && y <= Austritt.y) || (( Eintritt.y > Austritt.y) && y >= Austritt.y)) &&
		       ((( Eintritt.z <= Austritt.z) && z <= Austritt.z) || (( Eintritt.z > Austritt.z) && z >= Austritt.z)) ) {
		    
		    tex = vec4(texture3D(intensityTexture, vec3(x, y, z))).x;
		    
		    if (maxValue.w < tex) {
		       maxValue.w = tex;
		       maxValue.x = x;
		       maxValue.y = y;
		       maxValue.z = z;
		    }
		    x += dx;
		    y += dy;
		    z += dz;
		}
		
		clr = getColorValue(maxValue);
	} else {
	    // draw background
	    clr = vec4(0.0, 0.0, 0.0, 0.0);   
	}
	
	return clr;
}

vec4 ray_casting () {
// ray casting with maximum intensity

	vec4 Eintritt, Austritt, clr;
	float dx, dy, dz, x, y, z, xe, ye, tex, ze;
	vec4 col;    // akkumulierte Farbe + Opacity
	float opi;    // aktuelle Opacity
	vec3 ci;      // aktuelle Farbe
	vec4 tmp;    // temp var
	
	Eintritt = vec4( texture2D( frontTexture, vec2(gl_TexCoord[0].x, 1-gl_TexCoord[0].y) ) );
	Austritt = vec4( texture2D( backTexture, vec2(gl_TexCoord[0].x, 1-gl_TexCoord[0].y) ) );
	
	if (Eintritt.xyz != Austritt.xyz) {
		// cast a ray
		
		dx = (Austritt.x - Eintritt.x) / step;
		dy = (Austritt.y - Eintritt.y) / step;
		dz = (Austritt.z - Eintritt.z) / step;
		
		x = Eintritt.x;
		y = Eintritt.y;
		z = Eintritt.z;
		   
		while( ((( Eintritt.x <= Austritt.x) && x <= Austritt.x) || (( Eintritt.x > Austritt.x) && x >= Austritt.x)) && 
			   ((( Eintritt.y <= Austritt.y) && y <= Austritt.y) || (( Eintritt.y > Austritt.y) && y >= Austritt.y)) &&
		       ((( Eintritt.z <= Austritt.z) && z <= Austritt.z) || (( Eintritt.z > Austritt.z) && z >= Austritt.z)) ) {
		    
		    tex = vec4(texture3D(intensityTexture, vec3(x, y, z))).x;
		    tmp = getColorValue(vec4(x, y, z, tex)); // vec4(texture1D(transferTexture, tex));
		    ci = tmp.xyz;
		    opi = tmp.w*tex;
		    
            col.xyz += (1.0 - col.w) * opi * ci;
		    col.w += (1.0 - col.w) * opi;
		    
		    x += dx;
		    y += dy;
		    z += dz;
		}
		
		clr = col;
	} else {
	    // draw background
	    clr = vec4(0.0, 0.0, 0.0, 0.0);   
	}
	
	return clr;
}

void main(void)
{
   vec4 clr;
   
   if (renderUVs == 3) {
   // gradient
       clr = vec4(texture3D(gradientTexture, vec3(gl_TexCoord[0])));  
   }
   else if (renderUVs > 0) {
   // front and back sides for fbo
       vec3 texCoord = vec3(gl_TexCoord[0]);
	   clr = vec4 ( texCoord.x, texCoord.y, texCoord.z, 0.0);	
   }   	
   else if (renderUVs < 0) {
   // Slicing
	   float density = clamp(intensityLookup(), 0.0, 1.0);
	   clr = texture1D(transferTexture, density );
   }
   else {
       // ray casting
       if (renderTyp == 0) 
          clr = ray_casting();
       else if (renderTyp == 1) 
          clr = ray_casting_iso();
       else
          clr = ray_casting_max();
   }
   gl_FragColor = clr;
}
