uniform sampler3D densityTex;
uniform sampler2D backfaceTex;
uniform sampler2D histogramTex;
uniform int maxDim;
uniform float startSlice;
uniform float minDepth;
uniform float maxDepth;
varying vec4 pos;

void main(void)
 {
	float startSampleRate=2.0;
	float sampleRate=startSampleRate;
	float startLowSampleRate=0.4;
	float lowSampleRate=startLowSampleRate;
	
	int hit=0;
	
	float alphaPow=0.0;
 
	vec4 endPos=texture2D(backfaceTex, vec2(gl_FragCoord.x/2048.0, gl_FragCoord.y/2048.0)).rgba;
	vec3 startPos=gl_TexCoord[0].xyz;
	vec3 totalTraceDir=endPos.rgb-startPos;
	float traceLength=length(totalTraceDir);
	vec3 traceDir=totalTraceDir/(float(maxDim)*sampleRate);		// stepsize muss vom datensatz abhaengen
	float stepLength=length(traceDir);
	vec4 color=vec4(0.0,0.0,0.0,1.0);
	
	float accAlpha=0.0;
	
	float currentLength=0.0;
	vec3 currentPos=startPos;
	vec4 currentColor;
	
	float maxDensity=0.0;
	float curDensity=0.0;
	vec3 curNormal=vec3(1.0,0.0,0.0);
	
	//vec3 lightVec=normalize(vec3(1.0,1.0,1.0));
	vec3 lightVec=vec3(0.57735,0.57735,0.57735);
	vec3 halfVec=vec3(1.0,0.0,0.0);
	
	float diffuse=0.0;
	float shininess=2.0;
	float ambientFactor=0.2;
	float specularFactor=0.5;
	
	float specular=0.0;
	float borderline=0.0;
	
	vec3 viewVec=normalize(-pos.xyz);
	
	float startDepth=-(pos.z-maxDepth)/(maxDepth-minDepth);
	float currentDepth=startDepth;
	
	while (currentLength<traceLength && accAlpha<0.9) {
		
		curDensity=texture3D(densityTex, currentPos).r;
		currentColor=vec4(texture2D(histogramTex, vec2(curDensity, 0.75)));
		
		//if (currentColor.a>0.0 && currentLength>startSlice) {
		if ((currentColor.a>0.01 && currentDepth>startSlice) || borderline>0.0) {
			if (hit==0) {
				borderline=stepLength;
				currentPos-=traceDir;
				currentLength-=stepLength;
				curDensity=texture3D(densityTex, currentPos).r;
				currentColor=vec4(texture2D(histogramTex, vec2(curDensity, 0.75)));
				
				traceDir=totalTraceDir/(float(maxDim)*sampleRate);		// stepsize muss vom datensatz abhaengen
				stepLength=length(traceDir);
			}
		
			hit=1;
			
			
			borderline-=stepLength;
		
			if (currentDepth>startSlice) {
				curNormal=texture3D(densityTex, currentPos).gba*2.0-1.0;
				curNormal=gl_NormalMatrix*curNormal;
			
				diffuse=max(0.0,dot(curNormal,lightVec));
				
				halfVec=reflect(-lightVec,curNormal);
				
				specular=specularFactor*pow(max(0.0, dot(halfVec, viewVec)),shininess);
				
				currentColor.rgb=currentColor.rgb*diffuse+currentColor.rgb*ambientFactor;
				currentColor.rgb+=specular;
				
				//color = vec4(color.rgb*(1.0-currentColor.a),1.0) + vec4(currentColor.rgb*currentColor.a, 1.0);
				color = vec4(color.rgb+(1.0-accAlpha)*currentColor.rgb*currentColor.a/sampleRate,1.0);
			
				accAlpha+=(1.0-accAlpha)*currentColor.a/sampleRate;
			}
		} else {
			hit=0;
			traceDir=totalTraceDir/(float(maxDim)*lowSampleRate);
			stepLength=length(traceDir);
		}
	
		/*alphaPow=pow(accAlpha,4.0);
		sampleRate=startSampleRate-alphaPow*startSampleRate;
		lowSampleRate=startLowSampleRate-alphaPow*startLowSampleRate;*/
	
		currentPos+=traceDir;
		currentLength+=stepLength;
		
		currentDepth=startDepth+currentLength/traceLength*(endPos.a-startDepth);
	}
	
	//color=vec4(maxDensity,maxDensity,maxDensity,traceLength);
	//color=vec4(texture2D(histogramTex, vec2(maxDensity, 0.75)));

	//color=vec4(traceDir.x,traceDir.y,traceDir.z,1.0);

	gl_FragColor=color;
	 
 }
