uniform sampler3D volume_tex;
uniform sampler2D front_tex;
uniform sampler2D back_tex;
uniform sampler1D transfer_tex;
uniform sampler3D gradient_tex;

uniform float canvas_width, canvas_height;
uniform float stepsize;
uniform int mode;
uniform int gradient_selected;

void main(void) {
	
	const int maxrange = 1024;
		
	// compute coords to look up in the FBOs (canvas_width is power of two!)
	vec2 fbo_coord = vec2(gl_FragCoord.x / canvas_width, gl_FragCoord.y / canvas_height);
		
	vec4 entry_point = texture2D(front_tex, fbo_coord);
	vec4 exit_point = texture2D(back_tex, fbo_coord);
	
	float dist = distance(entry_point, exit_point);
	vec3 dir = (exit_point.xyz - entry_point.xyz);
	float len = length(dir);
	vec3 norm_dir = normalize(dir);
	vec3 delta_dir = norm_dir*stepsize;
	float delta_dir_length = length(delta_dir);
	
	vec3 point = entry_point.xyz;
	
	// initialize
	float alpha_acc = 0.0;
	float length_acc = 0.0;
	vec4 col_volume = vec4(0.0, 0.0, 0.0, 0.0);
	float alpha_volume = 0.0;
	
	vec4 max = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 intensity = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 gradient_vec = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 transfer_col = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 transfer_alpha = vec4(0.0, 0.0, 0.0, 0.0);
		
	if (entry_point.w == 0.0) 
		gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);
	else {
		
		for(int i = 0; i < maxrange && length_acc < len && intensity.a <= 1.0 ; i++) {
	
			col_volume = texture3D(volume_tex, point);
			transfer_col = texture1D(transfer_tex, col_volume.x);
			//transfer_alpha = texture1D(transfer_tex, gradient_vec.w);
			
			if (mode == 1) {			// ray casting
				transfer_col.a *= col_volume.x;
				
				if (gradient_selected == 1) {
					gradient_vec = texture3D(gradient_tex, point);
					transfer_col.a *= gradient_vec.w; // hopefully!
				}
				
				//transfer_col.a = transfer_alpha.a;
				intensity.rgb += (1.0 - intensity.a) * transfer_col.rgb * transfer_col.a;
				intensity.a += (1.0 - intensity.a) * transfer_col.a;
				
				if (intensity.r == 1.0 || intensity.g == 1.0 || intensity.b == 1.0) {
					break;
				}
				
			} 
			else if (mode == 2) {		// maximum intensity projection
				if (max.r < col_volume.r) {
					intensity = transfer_col;
					max = col_volume;
				}
			}
			
			point += delta_dir;
			length_acc += delta_dir_length;
		}
	}
	
	gl_FragColor = intensity;	
}