/*
 * Decompiled with CFR 0.152.
 */
package visualize;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.FloatBuffer;

public class Volume {
    private int width;
    private int height;
    private int depth;
    private FloatBuffer bufferedData;
    private FloatBuffer bufferedGradientData;
    private int[] histogram;
    private float[] histogramNormalized;
    private int histoMax;

    public Volume(File file) {
        System.out.println("Reading File: " + file.getAbsolutePath() + "...");
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(file));
            byte[] bytes = new byte[2];
            stream.read(bytes);
            this.width = Math.abs(this.convertToShort(bytes));
            stream.read(bytes);
            this.height = Math.abs(this.convertToShort(bytes));
            stream.read(bytes);
            this.depth = Math.abs(this.convertToShort(bytes));
            System.out.println("Size x: " + this.width + " Size y: " + this.height + " Size z: " + this.depth);
            int iSlice = this.width * this.height;
            int iSize = iSlice * this.depth;
            float[] data = new float[iSize];
            this.initHistogram();
            int z = 0;
            while (z < this.depth) {
                int y = 0;
                while (y < this.height) {
                    int x = 0;
                    while (x < this.width) {
                        stream.read(bytes);
                        data[x + y * this.width + z * iSlice] = this.convertToFloat(bytes);
                        this.feedHistogram(data[x + y * this.width + z * iSlice]);
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            this.bufferedData = FloatBuffer.wrap(data);
            this.computeGradient(data);
            this.normalizeHistogram();
            System.out.println("Finished reading File: " + file.getAbsolutePath());
        }
        catch (IOException ioe) {
            System.out.println("I couldn't read the file: " + file.getAbsolutePath());
            return;
        }
    }

    private void computeGradient(float[] data) {
        float[] gData = new float[data.length * 3];
        int iSlice = this.width * this.height;
        int z = 1;
        while (z < this.depth - 1) {
            int y = 1;
            while (y < this.height - 1) {
                int x = 1;
                while (x < this.width - 1) {
                    gData[x + y * this.width + z * iSlice] = (data[x + 1 + y * this.width + z * iSlice] - data[x - 1 + y * this.width + z * iSlice]) / 2.0f;
                    gData[x + y * this.width + z * iSlice + 1] = (data[x + (y * this.width + 1) + z * iSlice] - data[x + (y * this.width - 1) + z * iSlice]) / 2.0f;
                    gData[x + y * this.width + z * iSlice + 2] = (data[x + y * this.width + (z * iSlice + 1)] - data[x + y * this.width + (z * iSlice - 1)]) / 2.0f;
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        this.bufferedGradientData = FloatBuffer.wrap(gData);
    }

    private void initHistogram() {
        this.histogram = new int[256];
        this.histogramNormalized = new float[256];
        this.histoMax = 1;
    }

    private void feedHistogram(float value) {
        int grayValue = Math.round(value * 255.0f);
        if (grayValue == 0) {
            return;
        }
        int n = grayValue;
        this.histogram[n] = this.histogram[n] + 1;
        if (this.histogram[grayValue] > this.histogram[this.histoMax]) {
            this.histoMax = grayValue;
        }
    }

    private void normalizeHistogram() {
        System.out.println("maximum: " + this.histoMax);
        int max = this.histogram[this.histoMax];
        int i = 0;
        while (i < 255) {
            this.histogramNormalized[i] = (float)this.histogram[i] / (float)max;
            ++i;
        }
    }

    private short convertToShort(byte[] bytes) {
        int unsignedByte0 = 0xFF & bytes[1];
        int unsignedByte1 = 0xFF & bytes[0];
        return (short)(unsignedByte0 << 8 | unsignedByte1);
    }

    private float convertToFloat(byte[] bytes) {
        int b0 = 0xFF & bytes[1];
        int b1 = 0xFF & bytes[0];
        int i = b0 << 8 | b1;
        return Math.min(1.0f, (float)i / 4095.0f);
    }

    public FloatBuffer getBufferedData() {
        return this.bufferedData;
    }

    public FloatBuffer getBufferedGradientData() {
        return this.bufferedGradientData;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.depth;
    }

    public float[] getHistogram() {
        return this.histogramNormalized;
    }
}

