/*
 * Decompiled with CFR 0.152.
 */
package visualize;

import java.nio.Buffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import visualize.ImageSaver;
import visualize.RayCasting;
import visualize.Volume;

public class VisCanvas
implements GLEventListener {
    private static final long serialVersionUID = 4522753397996321426L;
    public static final int X_DIR = 0;
    public static final int Y_DIR = 1;
    public static final int Z_DIR = 2;
    public static final int SLICING = 0;
    public static final int MIP = 1;
    public static final int ACCUMULATE = 2;
    public static final float EYE_X_INIT = 0.0f;
    public static final float EYE_Y_INIT = 0.0f;
    public static final float EYE_Z_INIT = 5.0f;
    public static final float ROTATE_X_INIT = 0.0f;
    public static final float ROTATE_Y_INIT = 0.0f;
    public static final float ROTATE_Z_INIT = 0.0f;
    public static final int VOLUME_TEX = 0;
    public static final int GRADIENT_TEX = 1;
    public static int canvasPOTWidth;
    public static int canvasPOTHeight;
    public static int canvasWidth;
    public static int canvasHeight;
    private int[] volumeTex = new int[2];
    private static int[] transTex;
    private int rendering;
    private Volume volume;
    private boolean newVolume;
    private float[] texCoord = new float[3];
    private float[] sliceCoord = new float[3];
    private float[] texSize = new float[3];
    private float[] eye = new float[3];
    private float[] camOffset = new float[3];
    private float[] rotate = new float[3];
    private int currentDir;
    private boolean planarView;
    private static int sliceProgram;
    private float canvasRatio;
    private int lastMouseX;
    private int lastMouseY;
    private GLU glu;
    private RayCasting rayCasting;
    private int glError;
    private boolean saveImage;
    private String fileName;

    static {
        transTex = new int[1];
    }

    public VisCanvas() {
        this.volumeTex[0] = 0;
        this.glu = new GLU();
        this.volume = null;
        this.newVolume = false;
        this.rayCasting = new RayCasting(this.glu);
        this.texCoord[0] = 0.0f;
        this.texCoord[1] = 0.0f;
        this.texCoord[2] = 0.0f;
        this.sliceCoord[0] = 0.0f;
        this.sliceCoord[1] = 0.0f;
        this.sliceCoord[2] = 0.0f;
        this.texSize[0] = 1.0f;
        this.texSize[1] = 1.0f;
        this.texSize[2] = 1.0f;
        this.eye[0] = 0.0f;
        this.eye[1] = 0.0f;
        this.eye[2] = 5.0f;
        this.camOffset[0] = 0.0f;
        this.camOffset[1] = 0.0f;
        this.camOffset[2] = 0.0f;
        this.rotate[0] = 0.0f;
        this.rotate[1] = 0.0f;
        this.rotate[2] = 0.0f;
        this.lastMouseX = 0;
        this.lastMouseY = 0;
        this.planarView = false;
        this.currentDir = 2;
        this.rendering = 0;
        this.glError = 0;
    }

    public void setVolume(Volume volume) {
        this.volume = volume;
        this.newVolume = true;
        this.flushCamera();
        System.out.println("Volume set: " + volume.getHeight() + "x" + volume.getWidth() + "x" + volume.getDepth());
    }

    public Volume getVolume() {
        return this.volume;
    }

    public void setTexCoord(int coord) {
        this.texCoord[0] = 0.0f;
        this.texCoord[1] = 0.0f;
        this.texCoord[2] = 0.0f;
        this.sliceCoord[0] = 0.0f;
        this.sliceCoord[1] = 0.0f;
        this.sliceCoord[2] = 0.0f;
        this.texCoord[this.currentDir] = (float)coord / 100.0f * this.texSize[this.currentDir];
        this.sliceCoord[this.currentDir] = (float)coord / 50.0f - 1.0f;
    }

    public void setRendering(int rendering) {
        this.rendering = rendering;
    }

    public void saveImage(String fileName) {
        this.saveImage = true;
        this.fileName = fileName;
    }

    public void flushCamera() {
        this.eye[0] = 0.0f;
        this.eye[1] = 0.0f;
        this.eye[2] = 5.0f;
        this.rotate[0] = 0.0f;
        this.rotate[1] = 0.0f;
        this.rotate[2] = 0.0f;
        this.camOffset[0] = 0.0f;
        this.camOffset[1] = 0.0f;
        this.camOffset[2] = 0.0f;
    }

    private int getNextPowerOfTwo(int number) {
        int power = 1;
        while (power < number) {
            power *= 2;
        }
        return power;
    }

    private void setTexSize(int[] size) {
        this.texSize[0] = (float)this.volume.getWidth() / (float)size[0];
        this.texSize[1] = (float)this.volume.getHeight() / (float)size[1];
        this.texSize[2] = (float)this.volume.getDepth() / (float)size[2];
        this.rayCasting.setTexSize(this.texSize);
    }

    public void changeDirection(int direction) {
        if (direction < 0 || direction > 2) {
            System.out.println("The direction: " + direction + " is not defined!");
        } else {
            this.currentDir = direction;
        }
    }

    public void display(GLAutoDrawable drawable) {
        GL gl = drawable.getGL();
        gl.glClear(16640);
        gl.glPushMatrix();
        gl.glRotatef(this.rotate[0], 0.0f, 1.0f, 0.0f);
        gl.glRotatef(this.rotate[1], 1.0f, 0.0f, 0.0f);
        gl.glRotatef(this.rotate[2], 0.0f, 0.0f, 1.0f);
        if (this.volume != null && this.newVolume) {
            this.uploadTexture(gl);
            this.rayCasting.createFBO(gl);
        } else if (this.rendering == 0 && this.volume != null) {
            this.rayCasting.generateTColors(gl);
            gl.glUseProgram(sliceProgram);
            gl.glActiveTexture(33988);
            gl.glBindTexture(3552, transTex[0]);
            gl.glActiveTexture(33985);
            gl.glBindTexture(32879, this.volumeTex[0]);
            gl.glUniform1iARB(gl.glGetUniformLocationARB(sliceProgram, "transfer_tex"), 4);
            gl.glUniform1iARB(gl.glGetUniformLocationARB(sliceProgram, "volume_tex"), 1);
            this.drawSlices(gl);
            gl.glUseProgram(0);
        } else if (this.rendering == 1 && this.volume != null) {
            this.rayCasting.render(gl);
        }
        gl.glPopMatrix();
        gl.glFlush();
        gl.glLoadIdentity();
        this.glu.gluLookAt((double)this.eye[0], (double)this.eye[1], (double)this.eye[2], (double)this.camOffset[0], (double)this.camOffset[1], (double)this.camOffset[0], 0.0, 1.0, 0.0);
        if (this.saveImage) {
            new ImageSaver(gl, this.fileName, canvasWidth, canvasHeight);
            this.saveImage = false;
        }
    }

    public void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
    }

    public void init(GLAutoDrawable drawable) {
        System.out.println("initializing GL...");
        GL gl = drawable.getGL();
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.rayCasting.initShader(gl);
        gl.glShadeModel(7425);
        gl.glHint(3152, 4354);
        this.glError = 0;
        this.glError = gl.glGetError();
        if (this.glError != 0) {
            System.out.println("Error while initializing GL: " + this.glu.gluErrorString(this.glError));
        } else {
            System.out.println("GL initialized CORRECTLY...");
        }
    }

    public void zoomObject(int direction) {
        this.eye[2] = (float)((double)this.eye[2] + (double)direction * 0.5);
    }

    public void translateObject(int x, int y) {
        int diffX = x - this.lastMouseX;
        int diffY = y - this.lastMouseY;
        float addX = 0.0f;
        float addY = 0.0f;
        if (Math.abs(diffX) < 50) {
            addX = (float)diffX * 0.01f;
        }
        if (Math.abs(diffY) < 50) {
            addY = (float)diffY * 0.01f;
        }
        this.eye[0] = this.eye[0] - addX;
        this.eye[1] = this.eye[1] + addY;
        this.camOffset[0] = this.camOffset[0] - addX;
        this.camOffset[1] = this.camOffset[1] + addY;
        this.lastMouseX = x;
        this.lastMouseY = y;
    }

    public void rotateObject(int x, int y) {
        int diffX = x - this.lastMouseX;
        int diffY = y - this.lastMouseY;
        float addX = 0.0f;
        float addY = 0.0f;
        if (Math.abs(diffX) < 50) {
            addX = (float)diffX * 0.4f;
        }
        if (Math.abs(diffY) < 50) {
            addY = (float)diffY * 0.4f;
        }
        this.rotate[0] = this.rotate[0] + addX;
        this.rotate[1] = this.rotate[1] + addY;
        this.lastMouseX = x;
        this.lastMouseY = y;
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        GL gl = drawable.getGL();
        canvasWidth = width;
        canvasHeight = height;
        canvasPOTWidth = this.getNextPowerOfTwo(width);
        canvasPOTHeight = this.getNextPowerOfTwo(height);
        if (canvasHeight == 0) {
            canvasHeight = 1;
        }
        this.canvasRatio = 1.0f * (float)canvasWidth / (float)canvasHeight;
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glViewport(0, 0, canvasWidth, canvasHeight);
        this.glu.gluPerspective(50.0, (double)this.canvasRatio, 0.0, 20.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        this.glu.gluLookAt((double)this.eye[0], (double)this.eye[1], (double)this.eye[2], 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        this.rayCasting.createFBO(gl);
        System.out.println("eyex: " + this.eye[0] + "eyeY: " + this.eye[1] + "eyeZ: " + this.eye[2]);
        System.out.println("canvas reshaped...");
    }

    private void uploadTexture(GL gl) {
        int depthOffset = 0;
        int[] texDim = new int[]{this.getNextPowerOfTwo(this.volume.getWidth()), this.getNextPowerOfTwo(this.volume.getHeight()), this.getNextPowerOfTwo(this.volume.getDepth())};
        this.setTexSize(texDim);
        if (this.texSize[2] != 1.0f) {
            depthOffset = 1;
        }
        gl.glEnable(32879);
        gl.glActiveTexture(33985);
        gl.glGenTextures(1, this.volumeTex, 0);
        gl.glBindTexture(32879, this.volumeTex[0]);
        gl.glTexEnvf(8960, 8704, 7681.0f);
        gl.glTexParameteri(32879, 10240, 9729);
        gl.glTexParameteri(32879, 10241, 9729);
        gl.glTexParameteri(32879, 10242, 33069);
        gl.glTexParameteri(32879, 10243, 33069);
        gl.glTexParameteri(32879, 32882, 33069);
        gl.glTexImage3D(32879, 0, 6409, texDim[0], texDim[1], texDim[2], 0, 6409, 5126, null);
        gl.glTexSubImage3D(32879, 0, 0, 0, depthOffset, this.volume.getWidth(), this.volume.getHeight(), this.volume.getDepth(), 6409, 5126, (Buffer)this.volume.getBufferedData());
        gl.glEnable(32879);
        gl.glActiveTexture(33989);
        gl.glGenTextures(1, this.volumeTex, 1);
        gl.glBindTexture(32879, this.volumeTex[1]);
        gl.glTexEnvf(8960, 8704, 7681.0f);
        gl.glTexParameteri(32879, 10240, 9729);
        gl.glTexParameteri(32879, 10241, 9729);
        gl.glTexParameteri(32879, 10242, 33069);
        gl.glTexParameteri(32879, 10243, 33069);
        gl.glTexParameteri(32879, 32882, 33069);
        gl.glTexImage3D(32879, 0, 6407, texDim[0], texDim[1], texDim[2], 0, 6407, 5126, null);
        gl.glTexSubImage3D(32879, 0, 0, 0, depthOffset, this.volume.getWidth(), this.volume.getHeight(), this.volume.getDepth(), 6407, 5126, (Buffer)this.volume.getBufferedGradientData());
        gl.glDisable(32879);
        this.rayCasting.setVolumeTex(this.volumeTex);
        gl.glLinkProgramARB(sliceProgram);
        RayCasting.checkLogInfo(gl, sliceProgram);
        this.newVolume = false;
        this.glError = 0;
        this.glError = gl.glGetError();
        if (this.glError != 0) {
            System.out.println("Error while uploading the Texture: " + this.glu.gluErrorString(this.glError));
        } else {
            System.out.println("Texture uploaded CORRECTLY: " + this.volumeTex[0]);
        }
    }

    private void drawSlices(GL gl) {
        gl.glEnable(32879);
        gl.glActiveTexture(33985);
        gl.glBindTexture(32879, this.volumeTex[0]);
        gl.glBegin(7);
        switch (this.currentDir) {
            case 0: {
                if (this.planarView) {
                    gl.glMultiTexCoord3f(33985, this.texCoord[0], 0.0f, 0.0f);
                    gl.glVertex3f(-1.0f, -1.0f, 0.0f);
                    gl.glMultiTexCoord3f(33985, this.texCoord[0], 1.0f, 0.0f);
                    gl.glVertex3f(1.0f, -1.0f, 0.0f);
                    gl.glMultiTexCoord3f(33985, this.texCoord[0], 1.0f, 1.0f);
                    gl.glVertex3f(1.0f, 1.0f, 0.0f);
                    gl.glMultiTexCoord3f(33985, this.texCoord[0], 0.0f, 1.0f);
                    gl.glVertex3f(-1.0f, 1.0f, 0.0f);
                    break;
                }
                gl.glMultiTexCoord3f(33985, this.texCoord[0], 0.0f, 0.0f);
                gl.glVertex3f(this.sliceCoord[0], -1.0f, -1.0f);
                gl.glMultiTexCoord3f(33985, this.texCoord[0], 1.0f, 0.0f);
                gl.glVertex3f(this.sliceCoord[0], 1.0f, -1.0f);
                gl.glMultiTexCoord3f(33985, this.texCoord[0], 1.0f, 1.0f);
                gl.glVertex3f(this.sliceCoord[0], 1.0f, 1.0f);
                gl.glMultiTexCoord3f(33985, this.texCoord[0], 0.0f, 1.0f);
                gl.glVertex3f(this.sliceCoord[0], -1.0f, 1.0f);
                break;
            }
            case 1: {
                if (this.planarView) {
                    gl.glMultiTexCoord3f(33985, 0.0f, this.texCoord[1], 0.0f);
                    gl.glVertex3f(-1.0f, -1.0f, 0.0f);
                    gl.glMultiTexCoord3f(33985, 1.0f, this.texCoord[1], 0.0f);
                    gl.glVertex3f(1.0f, -1.0f, 0.0f);
                    gl.glMultiTexCoord3f(33985, 1.0f, this.texCoord[1], 1.0f);
                    gl.glVertex3f(1.0f, 1.0f, 0.0f);
                    gl.glMultiTexCoord3f(33985, 0.0f, this.texCoord[1], 1.0f);
                    gl.glVertex3f(-1.0f, 1.0f, 0.0f);
                    break;
                }
                gl.glMultiTexCoord3f(33985, 0.0f, this.texCoord[1], 0.0f);
                gl.glVertex3f(-1.0f, this.sliceCoord[1], -1.0f);
                gl.glMultiTexCoord3f(33985, 1.0f, this.texCoord[1], 0.0f);
                gl.glVertex3f(1.0f, this.sliceCoord[1], -1.0f);
                gl.glMultiTexCoord3f(33985, 1.0f, this.texCoord[1], 1.0f);
                gl.glVertex3f(1.0f, this.sliceCoord[1], 1.0f);
                gl.glMultiTexCoord3f(33985, 0.0f, this.texCoord[1], 1.0f);
                gl.glVertex3f(-1.0f, this.sliceCoord[1], 1.0f);
                break;
            }
            case 2: {
                if (this.planarView) {
                    gl.glMultiTexCoord3f(33985, 0.0f, 0.0f, this.texCoord[2]);
                    gl.glVertex3f(-1.0f, -1.0f, 0.0f);
                    gl.glMultiTexCoord3f(33985, 1.0f, 0.0f, this.texCoord[2]);
                    gl.glVertex3f(1.0f, -1.0f, 0.0f);
                    gl.glMultiTexCoord3f(33985, 1.0f, 1.0f, this.texCoord[2]);
                    gl.glVertex3f(1.0f, 1.0f, 0.0f);
                    gl.glMultiTexCoord3f(33985, 0.0f, 1.0f, this.texCoord[2]);
                    gl.glVertex3f(-1.0f, 1.0f, 0.0f);
                    break;
                }
                gl.glMultiTexCoord3f(33985, 0.0f, 0.0f, this.texCoord[2]);
                gl.glVertex3f(-1.0f, -1.0f, this.sliceCoord[2]);
                gl.glMultiTexCoord3f(33985, 1.0f, 0.0f, this.texCoord[2]);
                gl.glVertex3f(1.0f, -1.0f, this.sliceCoord[2]);
                gl.glMultiTexCoord3f(33985, 1.0f, 1.0f, this.texCoord[2]);
                gl.glVertex3f(1.0f, 1.0f, this.sliceCoord[2]);
                gl.glMultiTexCoord3f(33985, 0.0f, 1.0f, this.texCoord[2]);
                gl.glVertex3f(-1.0f, 1.0f, this.sliceCoord[2]);
            }
        }
        gl.glEnd();
        gl.glDisable(32879);
    }

    public void setPlanarView(boolean planarView) {
        this.flushCamera();
        this.planarView = planarView;
    }

    public static void setSliceShader(int sp) {
        sliceProgram = sp;
    }

    public static void setTransTex(int[] tt) {
        transTex = tt;
    }
}

