/*
 * Decompiled with CFR 0.152.
 */
package visualize;

import visualize.Vector2Df;

public class Vector3Df
extends Vector2Df {
    public float z;

    public Vector3Df() {
        this.z = 0.0f;
    }

    public Vector3Df(float x, float y, float z) {
        super(x, y);
        this.z = z;
    }

    public Vector3Df(Vector3Df vec) {
        super(vec.x, vec.y);
        this.z = vec.z;
    }

    @Override
    public float length() {
        return (float)Math.sqrt(this.squaredLength());
    }

    @Override
    protected float squaredLength() {
        return super.squaredLength() + this.z * this.z;
    }

    @Override
    public void normalize() {
        super.normalize();
        this.z = 1.0f / this.length();
    }

    public Vector3Df crossProduct(Vector3Df vec1) {
        Vector3Df result = new Vector3Df();
        result.x = this.x * vec1.z - this.z * vec1.y;
        result.y = this.z * vec1.x - this.x * vec1.z;
        result.z = this.x * vec1.y - this.y * vec1.x;
        return result;
    }

    @Override
    public float dotProduct(Vector3Df vec1) {
        return this.dotProduct(vec1.x, vec1.y, vec1.z);
    }

    public float dotProduct(float x, float y, float z) {
        return super.dotProduct(x, y) + this.z * z;
    }
}

