/*
 * Decompiled with CFR 0.152.
 */
package visualize;

import com.sun.opengl.util.BufferUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.swing.JOptionPane;
import visualize.GradientColorPanel;
import visualize.GuiMain;
import visualize.VisCanvas;

public class RayCasting {
    public static final int X_DIR = 0;
    public static final int Y_DIR = 1;
    public static final int Z_DIR = 2;
    public static final int FBO_TEXTURE_FRONT = 0;
    public static final int FBO_FRONT = 1;
    public static final int FBO_TEXTURE_BACK = 2;
    public static final int FBO_BACK = 3;
    public static final int T_COLORS = 0;
    public static final int VOLUME_TEX = 0;
    public static final int GRADIENT_TEX = 1;
    private GLU glu;
    private int[] buffers = new int[4];
    private int[] volumeTex = new int[2];
    private int[] transTex = new int[1];
    private int vertShader;
    private int fragShader;
    private int rcProgram;
    private float[] texSize = new float[3];
    private static int shaderMode;
    private static int gradientSelected;
    private static float stepSize;
    protected static boolean tColorsChanged;

    public RayCasting(GLU glu) {
        this.glu = glu;
        this.texSize[0] = 1.0f;
        this.texSize[1] = 1.0f;
        this.texSize[2] = 1.0f;
        shaderMode = 1;
        stepSize = 0.01f;
        gradientSelected = 0;
        tColorsChanged = true;
    }

    public void initShader(GL gl) {
        String vertFile = "Shader/raycasting.vsh";
        String fragFile = "Shader/raycasting.fsh";
        String vertSliceFile = "Shader/slicing.vsh";
        String fragSliceFile = "Shader/slicing.fsh";
        this.vertShader = gl.glCreateShaderObjectARB(35633);
        this.fragShader = gl.glCreateShaderObjectARB(35632);
        this.rcProgram = gl.glCreateProgramObjectARB();
        int vertSliceShader = gl.glCreateShaderObjectARB(35633);
        int fragSliceShader = gl.glCreateShaderObjectARB(35632);
        int sliceProgram = gl.glCreateProgramObjectARB();
        String shaderSource = this.getShaderSource(vertFile);
        gl.glShaderSourceARB(this.vertShader, 1, new String[]{shaderSource}, null, 0);
        this.compileShader(gl, this.vertShader, this.rcProgram);
        shaderSource = this.getShaderSource(vertSliceFile);
        gl.glShaderSourceARB(vertSliceShader, 1, new String[]{shaderSource}, null, 0);
        this.compileShader(gl, vertSliceShader, sliceProgram);
        int glError = 0;
        glError = gl.glGetError();
        if (glError != 0) {
            System.out.println("Error while compiling vertex shader: " + this.glu.gluErrorString(glError));
        } else {
            System.out.println("Shader compiled...");
        }
        shaderSource = this.getShaderSource(fragFile);
        gl.glShaderSourceARB(this.fragShader, 1, new String[]{shaderSource}, null, 0);
        this.compileShader(gl, this.fragShader, this.rcProgram);
        shaderSource = this.getShaderSource(fragSliceFile);
        gl.glShaderSourceARB(fragSliceShader, 1, new String[]{shaderSource}, null, 0);
        this.compileShader(gl, fragSliceShader, sliceProgram);
        glError = 0;
        glError = gl.glGetError();
        if (glError != 0) {
            System.out.println("Error while compiling fragment shader: " + this.glu.gluErrorString(glError));
        } else {
            System.out.println("Shader compiled...");
        }
        VisCanvas.setSliceShader(sliceProgram);
        GuiMain.setStepSizeSlider(stepSize);
    }

    private String getShaderSource(String filename) {
        String shaderSource = "";
        try {
            InputStream test = this.getClass().getClassLoader().getResourceAsStream(filename);
            if (test == null) {
                JOptionPane.showMessageDialog(null, "ClassLoader is null", "Error", 0);
            }
            BufferedReader shaderReader = new BufferedReader(new InputStreamReader(test));
            StringWriter shaderWriter = new StringWriter();
            String line = shaderReader.readLine();
            while (line != null) {
                shaderWriter.write(line);
                shaderWriter.write("\n");
                line = shaderReader.readLine();
            }
            shaderSource = shaderWriter.getBuffer().toString();
        }
        catch (IOException ioe) {
            System.out.println("I could not read from the file: " + filename);
            JOptionPane.showMessageDialog(null, "I couldn't read from the file: " + filename, "Error", 0);
        }
        return shaderSource;
    }

    private void compileShader(GL gl, int shader, int programObject) {
        gl.glCompileShaderARB(shader);
        RayCasting.checkLogInfo(gl, shader);
        gl.glAttachObjectARB(programObject, shader);
    }

    public static void checkLogInfo(GL gl, int shader) {
        IntBuffer iVal = BufferUtil.newIntBuffer((int)1);
        gl.glGetObjectParameterivARB(shader, 35716, iVal);
        int length = iVal.get();
        if (length <= 1) {
            return;
        }
        ByteBuffer infoLog = BufferUtil.newByteBuffer((int)length);
        iVal.flip();
        gl.glGetInfoLogARB(shader, length, iVal, infoLog);
        byte[] infoBytes = new byte[length];
        infoLog.get(infoBytes);
        System.out.println("GLSL Validation >> " + new String(infoBytes));
    }

    public void createFBO(GL gl) {
        int glError;
        gl.glActiveTexture(33986);
        gl.glGenTextures(1, this.buffers, 0);
        gl.glBindTexture(3553, this.buffers[0]);
        gl.glTexParameteri(3553, 10240, 9729);
        gl.glTexParameteri(3553, 10241, 9729);
        gl.glTexImage2D(3553, 0, 32856, VisCanvas.canvasPOTWidth, VisCanvas.canvasPOTHeight, 0, 6408, 5121, null);
        gl.glGenFramebuffersEXT(1, this.buffers, 1);
        gl.glBindFramebufferEXT(36160, this.buffers[1]);
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gl.glFramebufferTexture2DEXT(36160, 36064, 3553, this.buffers[0], 0);
        if (gl.glCheckFramebufferStatusEXT(36160) != 36053) {
            System.out.println("Framebuffer FRONT is not completed!");
        }
        if ((glError = gl.glGetError()) != 0) {
            System.out.println("Error while initializing framebuffers0: " + this.glu.gluErrorString(glError));
        } else {
            System.out.println("Framebuffers initialized CORRECTLY...");
        }
        gl.glActiveTexture(33987);
        gl.glGenTextures(1, this.buffers, 2);
        gl.glBindTexture(3553, this.buffers[2]);
        gl.glTexParameteri(3553, 10240, 9729);
        gl.glTexParameteri(3553, 10241, 9729);
        gl.glTexImage2D(3553, 0, 6408, VisCanvas.canvasPOTWidth, VisCanvas.canvasPOTHeight, 0, 6408, 5121, null);
        gl.glGenFramebuffersEXT(1, this.buffers, 3);
        gl.glBindFramebufferEXT(36160, this.buffers[3]);
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gl.glFramebufferTexture2DEXT(36160, 36064, 3553, this.buffers[2], 0);
        if (gl.glCheckFramebufferStatusEXT(36160) != 36053) {
            System.out.println("Framebuffer BACK is not completed!");
        }
        if ((glError = gl.glGetError()) != 0) {
            System.out.println("Error while initializing framebuffers: " + this.glu.gluErrorString(glError));
        } else {
            System.out.println("Framebuffers initialized CORRECTLY...");
        }
        gl.glEnable(32879);
        gl.glLinkProgramARB(this.rcProgram);
        gl.glUseProgramObjectARB(this.rcProgram);
        gl.glActiveTexture(33985);
        gl.glBindTexture(32879, this.volumeTex[0]);
        gl.glUniform1iARB(gl.glGetUniformLocationARB(this.rcProgram, "volume_tex"), 1);
        gl.glUniform1iARB(gl.glGetUniformLocationARB(this.rcProgram, "front_tex"), 2);
        gl.glUniform1iARB(gl.glGetUniformLocationARB(this.rcProgram, "back_tex"), 3);
        gl.glUniform1iARB(gl.glGetUniformLocationARB(this.rcProgram, "transfer_tex"), 4);
        gl.glActiveTexture(33989);
        gl.glBindTexture(32879, this.volumeTex[1]);
        gl.glUniform1iARB(gl.glGetUniformLocationARB(this.rcProgram, "gradient_tex"), 5);
        gl.glValidateProgramARB(this.rcProgram);
        RayCasting.checkLogInfo(gl, this.rcProgram);
        gl.glUseProgramObjectARB(0);
        gl.glBindFramebufferEXT(36160, 0);
        glError = gl.glGetError();
        if (glError != 0) {
            System.out.println("Error while initializing uniforms: " + this.glu.gluErrorString(glError));
        } else {
            System.out.println("Uniforms initialized CORRECTLY...");
        }
    }

    public void render(GL gl) {
        this.generateTColors(gl);
        gl.glTranslatef(this.texSize[0] * -1.0f, this.texSize[1] * -1.0f, this.texSize[2] * -1.0f);
        gl.glScalef(2.0f, 2.0f, 2.0f);
        this.renderBackface(gl);
        this.renderFrontface(gl);
        gl.glUseProgramObjectARB(this.rcProgram);
        this.setUniforms(gl);
        this.rayCastingPass(gl);
        gl.glUseProgramObjectARB(0);
        int glError = gl.glGetError();
        if (glError != 0) {
            System.out.println("GL ERROR RC: " + this.glu.gluErrorString(glError));
        }
    }

    private void setUniforms(GL gl) {
        gl.glUniform1iARB(gl.glGetUniformLocationARB(this.rcProgram, "front_tex"), 2);
        gl.glUniform1iARB(gl.glGetUniformLocationARB(this.rcProgram, "back_tex"), 3);
        gl.glActiveTexture(33988);
        gl.glBindTexture(3552, this.transTex[0]);
        gl.glUniform1iARB(gl.glGetUniformLocationARB(this.rcProgram, "transfer_tex"), 4);
        gl.glUniform1fARB(gl.glGetUniformLocationARB(this.rcProgram, "canvas_width"), (float)VisCanvas.canvasPOTWidth);
        gl.glUniform1fARB(gl.glGetUniformLocationARB(this.rcProgram, "canvas_height"), (float)VisCanvas.canvasPOTHeight);
        gl.glUniform1fARB(gl.glGetUniformLocationARB(this.rcProgram, "stepsize"), stepSize);
        gl.glUniform1iARB(gl.glGetUniformLocationARB(this.rcProgram, "mode"), shaderMode);
        gl.glUniform1iARB(gl.glGetUniformLocationARB(this.rcProgram, "gradient_selected"), gradientSelected);
    }

    private void renderBackface(GL gl) {
        gl.glEnable(2884);
        gl.glCullFace(1028);
        gl.glActiveTexture(33987);
        gl.glBindFramebufferEXT(36160, this.buffers[3]);
        gl.glClear(16384);
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.drawRGBCube(gl);
        gl.glBindFramebufferEXT(36160, 0);
        gl.glDisable(2884);
    }

    private void renderFrontface(GL gl) {
        gl.glEnable(2884);
        gl.glCullFace(1029);
        gl.glActiveTexture(33986);
        gl.glBindFramebufferEXT(36160, this.buffers[1]);
        gl.glClear(16384);
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.drawRGBCube(gl);
        gl.glBindFramebufferEXT(36160, 0);
        gl.glDisable(2884);
    }

    private void rayCastingPass(GL gl) {
        gl.glEnable(32879);
        gl.glActiveTexture(33985);
        gl.glBindTexture(32879, this.volumeTex[0]);
        gl.glClear(16384);
        gl.glEnable(2884);
        gl.glCullFace(1029);
        this.drawVolume(gl);
        gl.glDisable(2884);
        gl.glDisable(32879);
    }

    public void setTexSize(float[] texSize) {
        this.texSize = texSize;
    }

    public void setVolumeTex(int[] volumeTex) {
        this.volumeTex = volumeTex;
    }

    private void drawVolume(GL gl) {
        gl.glBegin(7);
        gl.glMultiTexCoord3f(33985, 0.0f, 0.0f, 0.0f);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glMultiTexCoord3f(33985, 0.0f, this.texSize[1], 0.0f);
        gl.glVertex3f(0.0f, this.texSize[1], 0.0f);
        gl.glMultiTexCoord3f(33985, this.texSize[0], this.texSize[1], 0.0f);
        gl.glVertex3f(this.texSize[0], this.texSize[1], 0.0f);
        gl.glMultiTexCoord3f(33985, this.texSize[0], 0.0f, 0.0f);
        gl.glVertex3f(this.texSize[0], 0.0f, 0.0f);
        gl.glMultiTexCoord3f(33985, 0.0f, 0.0f, this.texSize[2]);
        gl.glVertex3f(0.0f, 0.0f, this.texSize[2]);
        gl.glMultiTexCoord3f(33985, this.texSize[0], 0.0f, this.texSize[2]);
        gl.glVertex3f(this.texSize[0], 0.0f, this.texSize[2]);
        gl.glMultiTexCoord3f(33985, this.texSize[0], this.texSize[1], this.texSize[2]);
        gl.glVertex3f(this.texSize[0], this.texSize[1], this.texSize[2]);
        gl.glMultiTexCoord3f(33985, 0.0f, this.texSize[1], this.texSize[2]);
        gl.glVertex3f(0.0f, this.texSize[1], this.texSize[2]);
        gl.glMultiTexCoord3f(33985, 0.0f, this.texSize[1], 0.0f);
        gl.glVertex3f(0.0f, this.texSize[1], 0.0f);
        gl.glMultiTexCoord3f(33985, 0.0f, this.texSize[1], this.texSize[2]);
        gl.glVertex3f(0.0f, this.texSize[1], this.texSize[2]);
        gl.glMultiTexCoord3f(33985, this.texSize[0], this.texSize[1], this.texSize[2]);
        gl.glVertex3f(this.texSize[0], this.texSize[1], this.texSize[2]);
        gl.glMultiTexCoord3f(33985, this.texSize[0], this.texSize[1], 0.0f);
        gl.glVertex3f(this.texSize[0], this.texSize[1], 0.0f);
        gl.glMultiTexCoord3f(33985, 0.0f, 0.0f, 0.0f);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glMultiTexCoord3f(33985, this.texSize[0], 0.0f, 0.0f);
        gl.glVertex3f(this.texSize[0], 0.0f, 0.0f);
        gl.glMultiTexCoord3f(33985, this.texSize[0], 0.0f, this.texSize[2]);
        gl.glVertex3f(this.texSize[0], 0.0f, this.texSize[2]);
        gl.glMultiTexCoord3f(33985, 0.0f, 0.0f, this.texSize[2]);
        gl.glVertex3f(0.0f, 0.0f, this.texSize[2]);
        gl.glMultiTexCoord3f(33985, 0.0f, 0.0f, 0.0f);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glMultiTexCoord3f(33985, 0.0f, 0.0f, this.texSize[2]);
        gl.glVertex3f(0.0f, 0.0f, this.texSize[2]);
        gl.glMultiTexCoord3f(33985, 0.0f, this.texSize[1], this.texSize[2]);
        gl.glVertex3f(0.0f, this.texSize[1], this.texSize[2]);
        gl.glMultiTexCoord3f(33985, 0.0f, this.texSize[1], 0.0f);
        gl.glVertex3f(0.0f, this.texSize[1], 0.0f);
        gl.glMultiTexCoord3f(33985, this.texSize[0], 0.0f, 0.0f);
        gl.glVertex3f(this.texSize[0], 0.0f, 0.0f);
        gl.glMultiTexCoord3f(33985, this.texSize[0], this.texSize[1], 0.0f);
        gl.glVertex3f(this.texSize[0], this.texSize[1], 0.0f);
        gl.glMultiTexCoord3f(33985, this.texSize[0], this.texSize[1], this.texSize[2]);
        gl.glVertex3f(this.texSize[0], this.texSize[1], this.texSize[2]);
        gl.glMultiTexCoord3f(33985, this.texSize[0], 0.0f, this.texSize[2]);
        gl.glVertex3f(this.texSize[0], 0.0f, this.texSize[2]);
        gl.glEnd();
    }

    private void drawRGBCube(GL gl) {
        gl.glBegin(7);
        gl.glColor3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glColor3f(0.0f, this.texSize[1], 0.0f);
        gl.glVertex3f(0.0f, this.texSize[1], 0.0f);
        gl.glColor3f(this.texSize[0], this.texSize[1], 0.0f);
        gl.glVertex3f(this.texSize[0], this.texSize[1], 0.0f);
        gl.glColor3f(this.texSize[0], 0.0f, 0.0f);
        gl.glVertex3f(this.texSize[0], 0.0f, 0.0f);
        gl.glColor3f(0.0f, 0.0f, this.texSize[2]);
        gl.glVertex3f(0.0f, 0.0f, this.texSize[2]);
        gl.glColor3f(this.texSize[0], 0.0f, this.texSize[2]);
        gl.glVertex3f(this.texSize[0], 0.0f, this.texSize[2]);
        gl.glColor3f(this.texSize[0], this.texSize[1], this.texSize[2]);
        gl.glVertex3f(this.texSize[0], this.texSize[1], this.texSize[2]);
        gl.glColor3f(0.0f, this.texSize[1], this.texSize[2]);
        gl.glVertex3f(0.0f, this.texSize[1], this.texSize[2]);
        gl.glColor3f(0.0f, this.texSize[1], 0.0f);
        gl.glVertex3f(0.0f, this.texSize[1], 0.0f);
        gl.glColor3f(0.0f, this.texSize[1], this.texSize[2]);
        gl.glVertex3f(0.0f, this.texSize[1], this.texSize[2]);
        gl.glColor3f(this.texSize[0], this.texSize[1], this.texSize[2]);
        gl.glVertex3f(this.texSize[0], this.texSize[1], this.texSize[2]);
        gl.glColor3f(this.texSize[0], this.texSize[1], 0.0f);
        gl.glVertex3f(this.texSize[0], this.texSize[1], 0.0f);
        gl.glColor3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glColor3f(this.texSize[0], 0.0f, 0.0f);
        gl.glVertex3f(this.texSize[0], 0.0f, 0.0f);
        gl.glColor3f(this.texSize[0], 0.0f, this.texSize[2]);
        gl.glVertex3f(this.texSize[0], 0.0f, this.texSize[2]);
        gl.glColor3f(0.0f, 0.0f, this.texSize[2]);
        gl.glVertex3f(0.0f, 0.0f, this.texSize[2]);
        gl.glColor3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glColor3f(0.0f, 0.0f, this.texSize[2]);
        gl.glVertex3f(0.0f, 0.0f, this.texSize[2]);
        gl.glColor3f(0.0f, this.texSize[1], this.texSize[2]);
        gl.glVertex3f(0.0f, this.texSize[1], this.texSize[2]);
        gl.glColor3f(0.0f, this.texSize[1], 0.0f);
        gl.glVertex3f(0.0f, this.texSize[1], 0.0f);
        gl.glColor3f(this.texSize[0], 0.0f, 0.0f);
        gl.glVertex3f(this.texSize[0], 0.0f, 0.0f);
        gl.glColor3f(this.texSize[0], this.texSize[1], 0.0f);
        gl.glVertex3f(this.texSize[0], this.texSize[1], 0.0f);
        gl.glColor3f(this.texSize[0], this.texSize[1], this.texSize[2]);
        gl.glVertex3f(this.texSize[0], this.texSize[1], this.texSize[2]);
        gl.glColor3f(this.texSize[0], 0.0f, this.texSize[2]);
        gl.glVertex3f(this.texSize[0], 0.0f, this.texSize[2]);
        gl.glEnd();
    }

    protected void generateTColors(GL gl) {
        if (!tColorsChanged) {
            return;
        }
        FloatBuffer tColors = GradientColorPanel.getTransferFunction();
        gl.glEnable(3552);
        gl.glActiveTexture(33988);
        gl.glGenTextures(1, this.transTex, 0);
        gl.glBindTexture(3552, this.transTex[0]);
        gl.glTexEnvf(8960, 8704, 7681.0f);
        gl.glTexParameteri(3552, 10240, 9729);
        gl.glTexParameteri(3552, 10241, 9729);
        gl.glTexParameteri(3552, 10242, 33069);
        gl.glTexParameteri(3552, 10243, 33069);
        gl.glTexParameteri(3552, 32882, 33069);
        System.out.println("Size int buffer: " + tColors.limit());
        gl.glTexImage1D(3552, 0, 6408, 1024, 0, 6408, 5126, (Buffer)tColors);
        gl.glDisable(3552);
        VisCanvas.setTransTex(this.transTex);
        tColorsChanged = false;
    }

    public static void setShader(boolean mip) {
        shaderMode = !mip ? 1 : 2;
    }

    public static void setStepSize(int stepS) {
        stepSize = (float)stepS * 5.0E-4f + 0.003f;
    }

    public static void setTransferFunctionChanged(boolean transColors) {
        tColorsChanged = true;
    }

    public static void setGradientSelection(boolean gradientS) {
        gradientSelected = gradientS ? 1 : 0;
    }
}

