/*
 * Decompiled with CFR 0.152.
 */
package visualize;

import java.nio.FloatBuffer;
import visualize.Vector4Df;

public class Matrix3Df {
    public float xx = 1.0f;
    public float xy = 0.0f;
    public float xz = 0.0f;
    public float yx = 0.0f;
    public float yy = 1.0f;
    public float yz = 0.0f;
    public float zx = 0.0f;
    public float zy = 0.0f;
    public float zz = 0.0f;

    public static Matrix3Df rotationFromVector(Vector4Df vec) {
        Matrix3Df newM = new Matrix3Df();
        float n = vec.squaredLength();
        float s = n > 0.0f ? 2.0f / n : 0.0f;
        float xs = vec.x * s;
        float ys = vec.y * s;
        float zs = vec.z * s;
        float wx = vec.w * xs;
        float wy = vec.w * ys;
        float wz = vec.w * zs;
        float xx = vec.x * xs;
        float xy = vec.x * ys;
        float xz = vec.x * zs;
        float yy = vec.y * ys;
        float yz = vec.y * zs;
        float zz = vec.z * zs;
        newM.xx -= yy + zz;
        newM.yx = xy - wz;
        newM.zx = xz + wy;
        newM.xy = xy + wz;
        newM.yy -= xx + zz;
        newM.zy = yz - wx;
        newM.xz = xz - wy;
        newM.yz = yz + wx;
        newM.zz -= xx + yy;
        return newM;
    }

    public void multMatrix3Df(Matrix3Df m) {
        this.xx = this.xx * m.xx + this.xy * m.yx + this.xz * m.zx;
        this.xy = this.xx * m.xy + this.xy * m.yy + this.xz * m.zy;
        this.xz = this.xx * m.xz + this.xy * m.yz + this.xz * m.zz;
        this.yx = this.yx * m.xx + this.yy * m.yx + this.yz * m.zx;
        this.yy = this.yx * m.xy + this.yy * m.yy + this.yz * m.zy;
        this.yz = this.yx * m.xz + this.yy * m.yz + this.yz * m.zz;
        this.zx = this.zx * m.xx + this.zy * m.yx + this.zz * m.zx;
        this.zy = this.zx * m.xy + this.zy * m.yy + this.zz * m.zy;
        this.zz = this.zx * m.xz + this.zy * m.yz + this.zz * m.zz;
    }

    public FloatBuffer getFloatBuffer() {
        float[] f = new float[]{this.xx, this.xy, this.xz, 0.0f, this.yx, this.yy, this.yz, 0.0f, this.zx, this.zy, this.zz, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        return FloatBuffer.wrap(f);
    }
}

