/*
 * Decompiled with CFR 0.152.
 */
package visualize;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import visualize.RayCasting;
import visualize.TransferPoint;

public class LineDrawPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 6829387871522035232L;
    private static int rectSize = 4;
    private static LinkedList<TransferPoint> points;
    private static int offSet;
    private ActionListener listener;
    private TransferPoint selectedPoint;
    private int[] histogram = new int[255];
    private boolean pointsChanged;

    static {
        offSet = 3;
    }

    public LineDrawPanel() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        TransferPoint tp1 = new TransferPoint(0, 0);
        TransferPoint tp2 = new TransferPoint(255, 100);
        points = new LinkedList();
        points.add(tp1);
        points.add(tp2);
        this.pointsChanged = true;
    }

    public void init() {
        TransferPoint tp1 = new TransferPoint(0, 0);
        TransferPoint tp2 = new TransferPoint(255, 100);
        points.clear();
        points.add(tp1);
        points.add(tp2);
        this.selectedPoint = null;
        this.pointsChanged = true;
        this.repaint();
        this.tellListenerNoSelection();
    }

    public LinkedList<TransferPoint> getPoints() {
        return points;
    }

    public void FTOpened() {
        this.repaint();
        this.tellListenerSelectionChanged();
        this.tellListenerNoSelection();
    }

    public void addActionListener(ActionListener listener) {
        this.listener = listener;
    }

    public void setHistogram(float[] histogramNormalized) {
        int height = this.getHeight() - 2 * offSet;
        int i = 0;
        while (i < this.histogram.length) {
            this.histogram[i] = Math.round(histogramNormalized[i] * (float)height);
            ++i;
        }
        this.repaint();
    }

    private TransferPoint convertPoint(Point point) {
        return new TransferPoint((int)Math.round((point.getX() - (double)offSet) * 256.0 / (double)(this.getWidth() - 2 * offSet)), 100 - (int)Math.round((point.getY() - (double)offSet) * 100.0 / (double)(this.getHeight() - 2 * offSet)));
    }

    private Point convertTransferPoint(TransferPoint transferPoint) {
        return new Point(Math.round((this.getWidth() - 2 * offSet) * transferPoint.getGrayValue() / 256) + offSet, Math.round((this.getHeight() - 2 * offSet) * (100 - transferPoint.getOpacity()) / 100) + offSet);
    }

    private TransferPoint getNearestTransferPoint(Point point) {
        TransferPoint transferPoint = this.convertPoint(point);
        TransferPoint nearestTransferPoint = null;
        TransferPoint tp = null;
        int toleranceX = 4;
        int toleranceY = 4;
        int i = 0;
        while (i < points.size()) {
            tp = points.get(i);
            if (tp.getGrayValue() - toleranceX < transferPoint.getGrayValue() & tp.getGrayValue() + toleranceX > transferPoint.getGrayValue() & tp.getOpacity() - toleranceY < transferPoint.getOpacity() & tp.getOpacity() + toleranceY > transferPoint.getOpacity()) {
                if (nearestTransferPoint == null) {
                    nearestTransferPoint = tp;
                } else if (Math.abs(nearestTransferPoint.getGrayValue() - transferPoint.getGrayValue()) > Math.abs(tp.getGrayValue() - transferPoint.getGrayValue())) {
                    nearestTransferPoint = tp;
                }
            }
            ++i;
        }
        return nearestTransferPoint;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (points == null) {
            return;
        }
        if (points.size() < 2) {
            return;
        }
        TransferPoint lastTransferPoint = points.getFirst();
        TransferPoint transferPoint = null;
        Point lastPoint = null;
        Point point = null;
        int barWidth = Math.round(((float)this.getWidth() - 2.0f * (float)offSet) / 255.0f);
        int i = 0;
        while (i < this.histogram.length) {
            graphics.setColor(Color.blue);
            graphics.fillRect(offSet + (i - 1) * barWidth, this.getHeight() - this.histogram[i] - offSet / 2, barWidth, this.histogram[i] - offSet / 2 + 1);
            ++i;
        }
        i = 1;
        while (i < points.size()) {
            transferPoint = points.get(i);
            lastPoint = this.convertTransferPoint(lastTransferPoint);
            point = this.convertTransferPoint(transferPoint);
            graphics.setColor(Color.BLACK);
            graphics.drawLine(lastPoint.x, lastPoint.y, point.x, point.y);
            if (this.selectedPoint != lastTransferPoint) {
                graphics.setColor(Color.GRAY);
            }
            graphics.fillRect(lastPoint.x - rectSize / 2, lastPoint.y - rectSize / 2, rectSize, rectSize);
            lastTransferPoint = transferPoint;
            ++i;
        }
        if (this.selectedPoint != transferPoint) {
            graphics.setColor(Color.GRAY);
        } else {
            graphics.setColor(Color.BLACK);
        }
        graphics.fillRect(point.x - rectSize / 2, point.y - rectSize / 2, rectSize, rectSize);
        if (this.pointsChanged) {
            RayCasting.setTransferFunctionChanged(false);
            this.pointsChanged = false;
        }
    }

    public int getSelectedGrayValue() {
        if (this.selectedPoint != null) {
            return this.selectedPoint.getGrayValue();
        }
        return -1;
    }

    public int getSelectedOpacityValue() {
        if (this.selectedPoint != null) {
            return this.selectedPoint.getOpacity();
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setSelectedGrayValue(String grayValueStr) {
        try {
            int grayValue = Integer.parseInt(grayValueStr);
            if (grayValue < 0 || grayValue > 255) {
                JOptionPane.showMessageDialog(null, "GrayValues must be in the ranges from 0 to 255", "Error", 0);
                return false;
            }
            if ((this.selectedPoint == points.getFirst() || this.selectedPoint == points.getLast()) & grayValue != this.selectedPoint.getGrayValue()) {
                JOptionPane.showMessageDialog(null, "The grayvalues of the first and the last interpolation-points can't be changed.", "Error", 0);
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= points.size()) {
                    this.selectedPoint.setGrayValue(grayValue);
                    Collections.sort(points);
                    return true;
                }
                if (points.get(i).getGrayValue() == grayValue & points.get(i) != this.selectedPoint) {
                    JOptionPane.showMessageDialog(null, "There is already an interpolation-point existing with this grayvalue. Please enter another grayvalue.", "Error", 0);
                    return false;
                }
                ++i;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "You have entered a non-integer value in the grayvalue textfield, which only allows integer values.", "Error", 0);
            return false;
        }
    }

    public boolean setSelectedOpacity(String opacityStr) {
        int opacity;
        block3: {
            try {
                opacity = Integer.parseInt(opacityStr);
                if (opacity >= 0 && opacity <= 100) break block3;
                JOptionPane.showMessageDialog(null, "Opacity values must be in the range from 0 to 100", "Error", 0);
                return false;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "You have entered a non-integer value in the opacity textfield, which only allows integer values.", "Error", 0);
                return false;
            }
        }
        this.selectedPoint.setOpacity(opacity);
        return true;
    }

    public void setSelectedPoint(String grayValueStr, String opacityStr) {
        if (this.setSelectedGrayValue(grayValueStr) && this.setSelectedOpacity(opacityStr)) {
            this.pointsChanged = true;
            this.repaint();
            return;
        }
        this.tellListenerSelectionChanged();
    }

    public void deleteSelectedPoint() {
        if (this.selectedPoint == points.getFirst() || this.selectedPoint == points.getLast()) {
            JOptionPane.showMessageDialog(null, "The first and the last interpolation-points can't be deleted.", "Error", 0);
        } else {
            points.remove(this.selectedPoint);
            this.selectedPoint = null;
            this.tellListenerNoSelection();
            this.pointsChanged = true;
            this.repaint();
        }
    }

    public void tellListenerSelectionChanged() {
        ActionEvent event = new ActionEvent(this, 23, "point selection changed");
        this.listener.actionPerformed(event);
    }

    public void tellListenerNoSelection() {
        ActionEvent event = new ActionEvent(this, 23, "point deselected");
        this.listener.actionPerformed(event);
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (me.isControlDown()) {
            TransferPoint transferPoint = this.convertPoint(me.getPoint());
            int i = 0;
            while (i < points.size()) {
                if (points.get(i).getGrayValue() == transferPoint.getGrayValue()) {
                    JOptionPane.showMessageDialog(null, "At this grayvalue there is an interpolation-points already existing. You can't add a point at this grayvalue.", "Error", 0);
                    return;
                }
                ++i;
            }
            points.add(transferPoint);
            Collections.sort(points);
            this.pointsChanged = true;
            this.repaint();
        }
        TransferPoint lastSelectedPoint = this.selectedPoint;
        this.selectedPoint = this.getNearestTransferPoint(me.getPoint());
        if (lastSelectedPoint != this.selectedPoint) {
            if (this.selectedPoint == null) {
                this.tellListenerNoSelection();
            } else {
                this.tellListenerSelectionChanged();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.selectedPoint != null) {
            TransferPoint transferPoint = this.convertPoint(e.getPoint());
            if (this.selectedPoint != points.getFirst() & this.selectedPoint != points.getLast()) {
                int pos = points.indexOf(this.selectedPoint);
                if (points.get(pos - 1).getGrayValue() > transferPoint.getGrayValue()) {
                    this.selectedPoint.setGrayValue(points.get(pos - 1).getGrayValue() + 1);
                } else if (points.get(pos + 1).getGrayValue() < transferPoint.getGrayValue()) {
                    this.selectedPoint.setGrayValue(points.get(pos + 1).getGrayValue() - 1);
                } else {
                    this.selectedPoint.setGrayValue(transferPoint.getGrayValue());
                }
            }
            if (transferPoint.getOpacity() > 100) {
                this.selectedPoint.setOpacity(100);
            } else if (transferPoint.getOpacity() < 0) {
                this.selectedPoint.setOpacity(0);
            } else {
                this.selectedPoint.setOpacity(transferPoint.getOpacity());
            }
            this.tellListenerSelectionChanged();
            this.pointsChanged = true;
            this.repaint();
        }
    }

    public void mouseDragMoved(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        System.out.println("keypress");
    }

    public void keyReleased(KeyEvent e) {
        System.out.println("keypress");
    }

    public void keyTyped(KeyEvent e) {
        System.out.println("keypress");
    }

    public static float[] getInterpolatedOpacity() {
        float[] oHist = new float[1024];
        int curPoint = 1;
        TransferPoint p1 = points.getFirst();
        TransferPoint p2 = points.get(curPoint);
        float pointIdx = (float)p2.getGrayValue() / 255.0f;
        int i = 0;
        while (i < oHist.length) {
            float normIdx = (float)i / ((float)oHist.length - 1.0f);
            if (normIdx > pointIdx) {
                p1 = p2;
                p2 = points.get(++curPoint);
                pointIdx = (float)p2.getGrayValue() / 255.0f;
            }
            oHist[i] = LineDrawPanel.interpolatePoint(p1, p2, normIdx);
            ++i;
        }
        return oHist;
    }

    private static float interpolatePoint(TransferPoint p1, TransferPoint p2, float normIdx) {
        float normGrayP1 = (float)p1.getGrayValue() / 255.0f;
        float normGrayP2 = (float)p2.getGrayValue() / 255.0f;
        float weight = (normIdx - normGrayP1) / (normGrayP2 - normGrayP1);
        float opacity = (float)p1.getOpacity() * (1.0f - weight) + (float)p2.getOpacity() * weight / 100.0f;
        return opacity;
    }
}

