/*
 * Decompiled with CFR 0.152.
 */
package visualize;

import com.sun.org.apache.xerces.internal.impl.xpath.regex.ParseException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visualize.ColorHist;
import visualize.DatFilter;
import visualize.GradientColorPanel;
import visualize.LineDrawPanel;
import visualize.MFTFilter;
import visualize.PNGFilter;
import visualize.RayCasting;
import visualize.TransferPoint;
import visualize.VisCanvas;
import visualize.VisualizeMain;

public class GuiMain
extends JFrame
implements ActionListener,
ChangeListener,
FocusListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    private static final long serialVersionUID = -7609425377173567595L;
    static final int SLICE_MIN = 0;
    static final int SLICE_MAX = 100;
    static final int SLICE_INIT = 50;
    private JMenuBar menuBar = null;
    private JSlider sliceSlider = null;
    private static JSlider stepSizeSlider = null;
    private GLCanvas canvas = null;
    private GLCanvas histogramCanvas = null;
    private JPanel mainTransferPanel = null;
    private LineDrawPanel lineDrawPanel = null;
    private GradientColorPanel gradientColorPanel = null;
    private JButton showTransferFButton;
    private JTabbedPane leftPanel = null;
    private JCheckBox planarCBox = null;
    private JCheckBox mipCBox = null;
    private JCheckBox gradientCBox = null;
    private JFileChooser fileChooser = null;
    private MFTFilter mftFilter = null;
    private PNGFilter pngFilter = null;
    private DatFilter datFilter = null;
    private JTextField ipGrayValueTextField = null;
    private JTextField ipOpacityTextField = null;
    private JButton ipDeletePointButton = null;
    private JButton ipApplyChangesButton = null;
    private JTextField grGrayValueTextField = null;
    private JTextField grRedValueTextField = null;
    private JTextField grGreenValueTextField = null;
    private JTextField grBlueValueTextField = null;
    private JPanel settingsTopPanel = null;
    private JPanel settingsBottomPanel = null;
    private JPanel selectedColorPanel = null;
    private JPanel selectedLinePanel = null;
    private JPanel settingsTopBasicPanel = null;
    private JPanel settingsBottomBasicPanel = null;
    private JPanel settingsBottomBasicInnerPanel = null;
    private JPanel settingsBottomButtonPanel = null;
    private VisCanvas vc = null;

    public GuiMain(VisCanvas vc) {
        this.vc = vc;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println("I didn't load the Default System LookAndFeel");
        }
        this.setSize(new Dimension(1210, 510));
        this.setDefaultCloseOperation(3);
        this.setTitle("Visualize");
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.getCanvas(), "Center");
        this.add((Component)this.getPanel(), "West");
        this.add((Component)this.getTransferfunctionPanel(), "South");
        this.setJMenuBar(this.getMenu());
        this.setVisible(true);
        this.fileChooser = new JFileChooser();
        this.datFilter = new DatFilter();
        this.mftFilter = new MFTFilter();
        this.pngFilter = new PNGFilter();
    }

    private JMenuBar getMenu() {
        if (this.menuBar == null) {
            this.menuBar = new JMenuBar();
            JMenuItem loadItem = new JMenuItem("Load File");
            loadItem.setMnemonic(76);
            loadItem.setActionCommand("load file");
            JMenuItem loadTFItem = new JMenuItem("Load Transferfunction");
            loadTFItem.setMnemonic(79);
            loadTFItem.setActionCommand("load tf");
            JMenuItem saveTFItem = new JMenuItem("Save Transferfunction");
            saveTFItem.setMnemonic(83);
            saveTFItem.setActionCommand("save tf");
            JMenuItem saveImageItem = new JMenuItem("Save Image");
            saveImageItem.setMnemonic(73);
            saveImageItem.setActionCommand("save image");
            loadTFItem.addActionListener(this);
            saveTFItem.addActionListener(this);
            loadItem.addActionListener(this);
            saveImageItem.addActionListener(this);
            JMenu menu = new JMenu("File");
            menu.setMnemonic(70);
            menu.add(loadItem);
            menu.add(loadTFItem);
            menu.add(saveTFItem);
            menu.add(saveImageItem);
            this.menuBar.add(menu);
        }
        return this.menuBar;
    }

    private JTabbedPane getPanel() {
        this.leftPanel = new JTabbedPane();
        JPanel slicing = this.getSlicingPanel();
        JPanel raycasting = this.getRaycastingPanel();
        raycasting.setPreferredSize(new Dimension(200, 0));
        this.leftPanel.addTab("Slicing", slicing);
        this.leftPanel.addTab("Raycasting", raycasting);
        this.leftPanel.setMnemonicAt(0, 83);
        this.leftPanel.setMnemonicAt(1, 65);
        this.leftPanel.setPreferredSize(new Dimension(200, 0));
        this.leftPanel.addChangeListener(this);
        return this.leftPanel;
    }

    private JPanel getSlicingPanel() {
        JPanel slicing = new JPanel(new FlowLayout(0, 5, 10));
        JPanel dirPanel = new JPanel(new GridLayout(0, 1));
        slicing.setPreferredSize(new Dimension(200, 0));
        this.planarCBox = new JCheckBox("Planar View");
        this.planarCBox.setMnemonic(80);
        this.planarCBox.setActionCommand("planar");
        this.planarCBox.addActionListener(this);
        this.planarCBox.setPreferredSize(new Dimension(180, 20));
        slicing.add(this.planarCBox);
        ButtonGroup group = new ButtonGroup();
        JRadioButton xButton = new JRadioButton("X Direction");
        xButton.setMnemonic(88);
        xButton.setActionCommand("x");
        xButton.addActionListener(this);
        JRadioButton yButton = new JRadioButton("Y Direction");
        yButton.setMnemonic(89);
        yButton.setActionCommand("y");
        yButton.addActionListener(this);
        JRadioButton zButton = new JRadioButton("Z Direction");
        zButton.setMnemonic(90);
        zButton.setActionCommand("z");
        zButton.addActionListener(this);
        zButton.setSelected(true);
        group.add(xButton);
        group.add(yButton);
        group.add(zButton);
        dirPanel.add(xButton);
        dirPanel.add(yButton);
        dirPanel.add(zButton);
        slicing.add(dirPanel);
        this.sliceSlider = new JSlider(0, 0, 100, 50);
        this.sliceSlider.setPreferredSize(new Dimension(180, 50));
        this.sliceSlider.setMajorTickSpacing(50);
        this.sliceSlider.setMinorTickSpacing(10);
        this.sliceSlider.setPaintTicks(true);
        this.sliceSlider.setPaintLabels(true);
        this.sliceSlider.addChangeListener(this);
        slicing.add(this.sliceSlider);
        slicing.add(this.initResetButton());
        this.vc.changeDirection(2);
        this.vc.setTexCoord(50);
        return slicing;
    }

    private JButton initResetButton() {
        JButton resetButton = new JButton("Reset");
        resetButton.setMnemonic(82);
        resetButton.setActionCommand("reset");
        resetButton.addActionListener(this);
        return resetButton;
    }

    private JPanel getRaycastingPanel() {
        JPanel rayCasting = new JPanel(new FlowLayout(0, 5, 10));
        rayCasting.setPreferredSize(new Dimension(200, 0));
        this.mipCBox = new JCheckBox("MIP");
        this.mipCBox.setMnemonic(77);
        this.mipCBox.setActionCommand("mip");
        this.mipCBox.addActionListener(this);
        this.mipCBox.setPreferredSize(new Dimension(180, 20));
        rayCasting.add(this.mipCBox);
        stepSizeSlider = new JSlider(0, 0, 100, 50);
        stepSizeSlider.setPreferredSize(new Dimension(180, 50));
        stepSizeSlider.setMajorTickSpacing(50);
        stepSizeSlider.setMinorTickSpacing(10);
        stepSizeSlider.setPaintTicks(true);
        stepSizeSlider.setPaintLabels(true);
        stepSizeSlider.addChangeListener(this);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel("0.001"));
        labelTable.put(new Integer(100), new JLabel("0.5"));
        stepSizeSlider.setLabelTable(labelTable);
        rayCasting.add(stepSizeSlider);
        rayCasting.add(this.initResetButton());
        return rayCasting;
    }

    private JPanel getTransferfunctionPanel() throws ParseException {
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        JPanel titlePanel = new JPanel();
        JPanel mainTPanel = new JPanel();
        mainTPanel.setLayout(new BorderLayout());
        JPanel leftTPanel = new JPanel();
        leftTPanel.setLayout(new FlowLayout());
        leftTPanel.setPreferredSize(new Dimension(530, 240));
        JPanel rightTPanel = new JPanel();
        rightTPanel.setLayout(new FlowLayout(0));
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout(new BorderLayout());
        settingsPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.settingsTopPanel = new JPanel();
        this.settingsTopPanel.setLayout(new BorderLayout(2, 2));
        this.settingsTopPanel.setBorder(BorderFactory.createEtchedBorder());
        this.settingsTopBasicPanel = new JPanel();
        this.settingsBottomPanel = new JPanel();
        this.settingsBottomPanel.setLayout(new GridLayout(5, 1, 2, 3));
        this.settingsBottomPanel.setBorder(BorderFactory.createBevelBorder(-1, Color.BLACK, this.getBackground()));
        this.settingsBottomBasicPanel = new JPanel();
        titlePanel.setLayout(new FlowLayout(0));
        titlePanel.add(new JLabel("Transferfunction"));
        this.showTransferFButton = new JButton("Hide");
        titlePanel.add(this.showTransferFButton);
        this.showTransferFButton.addActionListener(this);
        this.showTransferFButton.setActionCommand("transfer");
        titlePanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.lineDrawPanel = new LineDrawPanel();
        this.lineDrawPanel.setLayout(new BorderLayout());
        this.lineDrawPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.lineDrawPanel.setPreferredSize(new Dimension(520, 200));
        this.lineDrawPanel.addActionListener(this);
        JPanel test = new JPanel();
        this.gradientColorPanel = new GradientColorPanel();
        this.gradientColorPanel.setPreferredSize(new Dimension(520, 25));
        this.gradientColorPanel.addActionListener(this);
        test.add(this.gradientColorPanel);
        JPanel settingsTopTopPanel = new JPanel();
        settingsTopTopPanel.setLayout(new GridLayout(1, 2));
        settingsTopTopPanel.add(new JLabel("Opacity-Interpolation:"));
        JButton resetLines = new JButton("Reset");
        resetLines.setActionCommand("reset opacity");
        resetLines.addActionListener(this);
        settingsTopTopPanel.add(resetLines);
        this.settingsTopPanel.add("North", settingsTopTopPanel);
        this.selectedLinePanel = new JPanel();
        this.selectedLinePanel.add(new JLabel("Selected:"));
        this.selectedLinePanel.setLayout(new GridLayout(1, 2));
        this.settingsTopBasicPanel.setLayout(new GridLayout(3, 2, 2, 3));
        this.settingsTopBasicPanel.add(new JLabel("GrayValue:"));
        this.ipGrayValueTextField = new JTextField();
        this.settingsTopBasicPanel.add(this.ipGrayValueTextField);
        this.settingsTopBasicPanel.add(new JLabel("Opacity"));
        this.ipOpacityTextField = new JTextField();
        this.settingsTopBasicPanel.add(this.ipOpacityTextField);
        this.ipDeletePointButton = new JButton("Delete Point");
        this.ipApplyChangesButton = new JButton("Apply Changes");
        this.settingsTopBasicPanel.add(this.ipDeletePointButton);
        this.ipApplyChangesButton.addActionListener(this);
        this.ipApplyChangesButton.setActionCommand("apply ipchanges");
        this.ipDeletePointButton.addActionListener(this);
        this.ipDeletePointButton.setActionCommand("delete point");
        this.settingsTopBasicPanel.add(this.ipApplyChangesButton);
        this.settingsTopPanel.add("South", this.settingsTopBasicPanel);
        settingsPanel.add("North", this.settingsTopPanel);
        this.settingsTopPanel.add(this.selectedLinePanel);
        JPanel settingsBottomTitlePanel = new JPanel();
        settingsBottomTitlePanel.setLayout(new GridLayout(1, 2, 2, 3));
        settingsBottomTitlePanel.add(new JLabel("Color-Interpolation:"));
        JButton resetColorButton = new JButton("Reset");
        resetColorButton.setActionCommand("reset color");
        resetColorButton.addActionListener(this);
        settingsBottomTitlePanel.add(resetColorButton);
        this.settingsBottomPanel.add(settingsBottomTitlePanel);
        this.selectedColorPanel = new JPanel();
        this.selectedColorPanel.add(new JLabel("Selected:"));
        this.selectedColorPanel.setLayout(new GridLayout(1, 2));
        this.settingsBottomBasicPanel.setLayout(new GridLayout(1, 2));
        this.grGrayValueTextField = new JTextField();
        this.settingsBottomBasicPanel.add(new JLabel("GrayValue:"));
        this.settingsBottomBasicPanel.add(this.grGrayValueTextField);
        this.settingsBottomBasicInnerPanel = new JPanel();
        this.settingsBottomBasicInnerPanel.setLayout(new GridLayout(1, 6));
        this.grRedValueTextField = new JTextField();
        this.grGreenValueTextField = new JTextField();
        this.grBlueValueTextField = new JTextField();
        this.settingsBottomBasicInnerPanel.add(new JLabel("Red:"));
        this.settingsBottomBasicInnerPanel.add(this.grRedValueTextField);
        this.settingsBottomBasicInnerPanel.add(new JLabel("Blue:"));
        this.settingsBottomBasicInnerPanel.add(this.grGreenValueTextField);
        this.settingsBottomBasicInnerPanel.add(new JLabel("Green:"));
        this.settingsBottomBasicInnerPanel.add(this.grBlueValueTextField);
        this.settingsBottomButtonPanel = new JPanel();
        this.settingsBottomButtonPanel.setLayout(new GridLayout(1, 2, 2, 3));
        JButton grDeletePointButton = new JButton("Delete Point");
        JButton grApplyChangesButton = new JButton("Apply Changes");
        grApplyChangesButton.setActionCommand("apply grchanges");
        grApplyChangesButton.addActionListener(this);
        grDeletePointButton.setActionCommand("delete grpoint");
        grDeletePointButton.addActionListener(this);
        this.settingsBottomButtonPanel.add(grDeletePointButton);
        this.settingsBottomButtonPanel.add(grApplyChangesButton);
        leftTPanel.add(this.lineDrawPanel);
        leftTPanel.add(test);
        this.settingsBottomPanel.add(this.selectedColorPanel);
        this.settingsBottomPanel.add(this.settingsBottomBasicPanel);
        this.settingsBottomPanel.add(this.settingsBottomBasicInnerPanel);
        this.settingsBottomPanel.add(this.settingsBottomButtonPanel);
        this.enableComponents(this.settingsTopBasicPanel, false);
        this.enableComponents(this.selectedLinePanel, false);
        this.enableComponents(this.settingsBottomBasicPanel, false);
        this.enableComponents(this.settingsBottomBasicInnerPanel, false);
        this.enableComponents(this.settingsBottomButtonPanel, false);
        this.enableComponents(this.selectedColorPanel, false);
        settingsPanel.add("Center", this.settingsBottomPanel);
        rightTPanel.add(settingsPanel);
        mainTPanel.add("West", leftTPanel);
        bottomPanel.add("North", titlePanel);
        bottomPanel.add(mainTPanel);
        mainTPanel.add("Center", rightTPanel);
        this.setMainTransferPanel(mainTPanel);
        return bottomPanel;
    }

    protected void setMainTransferPanel(JPanel panel) {
        this.mainTransferPanel = panel;
    }

    protected GLCanvas getCanvas() {
        if (this.canvas == null) {
            GLCapabilities caps = new GLCapabilities();
            caps.setDoubleBuffered(true);
            caps.setHardwareAccelerated(true);
            this.canvas = new GLCanvas(caps);
            this.canvas.setPreferredSize(new Dimension(800, 0));
            this.canvas.addGLEventListener((GLEventListener)this.vc);
            this.canvas.addMouseMotionListener((MouseMotionListener)this);
            this.canvas.addMouseWheelListener((MouseWheelListener)this);
            this.canvas.addKeyListener((KeyListener)this);
        }
        return this.canvas;
    }

    protected GLCanvas getHistogramCanvas() {
        if (this.histogramCanvas == null) {
            GLCapabilities caps = new GLCapabilities();
            caps.setDoubleBuffered(true);
            caps.setHardwareAccelerated(true);
            this.histogramCanvas = new GLCanvas(caps);
            this.histogramCanvas.setPreferredSize(new Dimension(256, 50));
            this.histogramCanvas.addGLEventListener((GLEventListener)this.vc);
        }
        return this.histogramCanvas;
    }

    protected void setCanvas(GLCanvas canvas) {
        this.canvas = canvas;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("load file")) {
            this.fileChooser.setSelectedFile(null);
            this.fileChooser.updateUI();
            this.fileChooser.removeChoosableFileFilter(this.pngFilter);
            this.fileChooser.removeChoosableFileFilter(this.mftFilter);
            this.fileChooser.setFileFilter(this.datFilter);
            int returnVal = this.fileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                File file = this.fileChooser.getSelectedFile();
                VisualizeMain.loadFile(file);
            } else {
                System.out.println("opening canceled");
            }
        } else if (ae.getActionCommand().equals("x")) {
            this.vc.changeDirection(0);
            this.vc.setTexCoord(this.sliceSlider.getValue());
        } else if (ae.getActionCommand().equals("y")) {
            this.vc.changeDirection(1);
            this.vc.setTexCoord(this.sliceSlider.getValue());
        } else if (ae.getActionCommand().equals("z")) {
            this.vc.changeDirection(2);
            this.vc.setTexCoord(this.sliceSlider.getValue());
        } else if (ae.getActionCommand().equals("transfer")) {
            if (this.mainTransferPanel.isVisible()) {
                this.showTransferFButton.setText("Show");
                this.mainTransferPanel.setVisible(false);
            } else {
                this.showTransferFButton.setText("Hide");
                this.mainTransferPanel.setVisible(true);
            }
        } else if (ae.getActionCommand().equals("reset")) {
            this.vc.flushCamera();
        } else if (ae.getActionCommand().equals("planar")) {
            this.vc.setPlanarView(this.planarCBox.isSelected());
        } else if (ae.getActionCommand().equals("mip")) {
            RayCasting.setShader(this.mipCBox.isSelected());
        } else if (ae.getActionCommand().equals("gradient")) {
            RayCasting.setGradientSelection(this.gradientCBox.isSelected());
        } else if (ae.getActionCommand().equals("point deselected")) {
            this.enableComponents(this.settingsTopBasicPanel, false);
            this.enableComponents(this.selectedLinePanel, false);
        } else if (ae.getActionCommand().equals("point selection changed")) {
            this.enableComponents(this.settingsTopBasicPanel, true);
            this.enableComponents(this.selectedLinePanel, true);
            this.ipGrayValueTextField.setText(Integer.toString(this.lineDrawPanel.getSelectedGrayValue()));
            this.ipOpacityTextField.setText(Integer.toString(this.lineDrawPanel.getSelectedOpacityValue()));
        } else if (ae.getActionCommand().equals("delete point")) {
            this.lineDrawPanel.deleteSelectedPoint();
        } else if (ae.getActionCommand().equals("apply ipchanges")) {
            this.lineDrawPanel.setSelectedPoint(this.ipGrayValueTextField.getText(), this.ipOpacityTextField.getText());
        } else if (ae.getActionCommand().equals("gradient selection changed")) {
            this.enableComponents(this.settingsBottomBasicPanel, true);
            this.enableComponents(this.selectedColorPanel, true);
            this.enableComponents(this.settingsBottomBasicInnerPanel, true);
            this.enableComponents(this.settingsBottomButtonPanel, true);
            this.grGrayValueTextField.setText(Integer.toString(this.gradientColorPanel.getSelectedGrayValue()));
            this.grRedValueTextField.setText(Integer.toString(this.gradientColorPanel.getSelectedRed()));
            this.grGreenValueTextField.setText(Integer.toString(this.gradientColorPanel.getSelectedGreen()));
            this.grBlueValueTextField.setText(Integer.toString(this.gradientColorPanel.getSelectedBlue()));
        } else if (ae.getActionCommand().equals("gradient deselected")) {
            this.enableComponents(this.settingsBottomBasicPanel, false);
            this.enableComponents(this.selectedColorPanel, false);
            this.enableComponents(this.settingsBottomBasicInnerPanel, false);
            this.enableComponents(this.settingsBottomButtonPanel, false);
        } else if (ae.getActionCommand().equals("apply grchanges")) {
            this.gradientColorPanel.setSelectedColorHist(this.grGrayValueTextField.getText(), this.grRedValueTextField.getText(), this.grGreenValueTextField.getText(), this.grBlueValueTextField.getText());
        } else if (ae.getActionCommand().equals("delete grpoint")) {
            this.gradientColorPanel.deleteSelectedColorHist();
        } else if (ae.getActionCommand().equals("save tf")) {
            this.fileChooser.setSelectedFile(null);
            this.fileChooser.updateUI();
            this.fileChooser.removeChoosableFileFilter(this.pngFilter);
            this.fileChooser.removeChoosableFileFilter(this.datFilter);
            this.fileChooser.setFileFilter(this.mftFilter);
            int returnVal = this.fileChooser.showSaveDialog(this);
            if (returnVal == 0) {
                File file = this.fileChooser.getSelectedFile();
                this.writeTFToFile(file.getAbsolutePath());
            } else {
                System.out.println("opening canceled");
            }
        } else if (ae.getActionCommand().equals("load tf")) {
            this.fileChooser.setSelectedFile(null);
            this.fileChooser.updateUI();
            this.fileChooser.removeChoosableFileFilter(this.pngFilter);
            this.fileChooser.removeChoosableFileFilter(this.datFilter);
            this.fileChooser.setFileFilter(this.mftFilter);
            int returnVal = this.fileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                File file = this.fileChooser.getSelectedFile();
                this.readTFFromFile(file.getAbsolutePath());
            } else {
                System.out.println("opening canceled");
            }
        } else if (ae.getActionCommand().equals("reset opacity")) {
            if (JOptionPane.showConfirmDialog(this, "Do you really want to reset the Opacity-Interpolation of the Transferfunction?", "Confirmation", 0) == 0) {
                this.lineDrawPanel.init();
            }
        } else if (ae.getActionCommand().equals("reset color")) {
            if (JOptionPane.showConfirmDialog(this, "Do you really want to reset the Color-Interpolation of the Transferfunction?", "Confirmation", 0) == 0) {
                this.gradientColorPanel.init();
            }
        } else if (ae.getActionCommand().equals("save image")) {
            this.fileChooser.setSelectedFile(null);
            this.fileChooser.updateUI();
            this.fileChooser.removeChoosableFileFilter(this.datFilter);
            this.fileChooser.removeChoosableFileFilter(this.mftFilter);
            this.fileChooser.setFileFilter(this.pngFilter);
            int returnVal = this.fileChooser.showSaveDialog(this);
            if (returnVal == 0) {
                System.out.println("writing file");
                File file = this.fileChooser.getSelectedFile();
                this.vc.saveImage(file + ".png");
            } else {
                System.out.println("opening canceled");
            }
        }
    }

    private void writeTFToFile(String fileName) {
        fileName = String.valueOf(fileName) + ".mft";
        PrintWriter pw = null;
        try {
            try {
                String line;
                FileWriter fw = new FileWriter(fileName);
                BufferedWriter bw = new BufferedWriter(fw);
                pw = new PrintWriter(bw);
                int i = 0;
                while (i < this.lineDrawPanel.getPoints().size()) {
                    line = String.valueOf(new Integer(this.lineDrawPanel.getPoints().get(i).getGrayValue()).toString()) + "/" + new Integer(this.lineDrawPanel.getPoints().get(i).getOpacity());
                    pw.println(line);
                    ++i;
                }
                pw.println("-");
                i = 0;
                while (i < this.gradientColorPanel.getColorPoints().size()) {
                    line = String.valueOf(new Integer(this.gradientColorPanel.getColorPoints().get(i).getGrayValue()).toString()) + "/" + new Integer(this.gradientColorPanel.getColorPoints().get(i).getColor().getRed()).toString() + "r" + new Integer(this.gradientColorPanel.getColorPoints().get(i).getColor().getGreen()).toString() + "g" + new Integer(this.gradientColorPanel.getColorPoints().get(i).getColor().getBlue()).toString() + "b";
                    pw.println(line);
                    ++i;
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Could'nt write File. We apologize.", "Error", 0);
                if (pw != null) {
                    pw.close();
                }
            }
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    public void readTFFromFile(String fileName) {
        block15: {
            BufferedReader in = null;
            try {
                try {
                    String line;
                    in = new BufferedReader(new FileReader(fileName));
                    this.lineDrawPanel.getPoints().clear();
                    this.gradientColorPanel.getColorPoints().clear();
                    boolean isLDPRead = false;
                    while ((line = in.readLine()) != null) {
                        int grayValue;
                        int pos;
                        if (line.equals("-")) {
                            isLDPRead = true;
                            continue;
                        }
                        if (!isLDPRead) {
                            pos = line.indexOf("/");
                            grayValue = Integer.parseInt(line.substring(0, pos));
                            int opacity = Integer.parseInt(line.substring(pos + 1, line.length()));
                            this.lineDrawPanel.getPoints().add(new TransferPoint(grayValue, opacity));
                            continue;
                        }
                        pos = line.indexOf("/");
                        int posR = line.indexOf("r");
                        int posG = line.indexOf("g");
                        int posB = line.indexOf("b");
                        grayValue = Integer.parseInt(line.substring(0, pos));
                        int red = Integer.parseInt(line.substring(pos + 1, posR));
                        int green = Integer.parseInt(line.substring(posR + 1, posG));
                        int blue = Integer.parseInt(line.substring(posG + 1, posB));
                        this.gradientColorPanel.getColorPoints().add(new ColorHist(grayValue, new Color(red, green, blue)));
                    }
                    this.lineDrawPanel.FTOpened();
                    this.gradientColorPanel.FTOpened();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Could'nt read File. We apologize.", "Error", 0);
                    if (in == null) break block15;
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void setStepSizeSlider(float value) {
        stepSizeSlider.setValue(Math.round(value * 2000.0f - 0.003f));
    }

    private void enableComponents(JPanel panel, boolean enabled) {
        Component[] components = panel.getComponents();
        if (components != null && components.length > 0) {
            int count = components.length;
            int i = 0;
            while (i < count) {
                components[i].setEnabled(enabled);
                if (components[i] instanceof JTextField) {
                    JTextField tf = (JTextField)components[i];
                    tf.setText("");
                } else if (components[i] instanceof JPanel) {
                    this.enableComponents((JPanel)components[i], enabled);
                }
                ++i;
            }
        }
    }

    public void histogramChanged(float[] histogram) {
        this.lineDrawPanel.setHistogram(histogram);
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (ce.getSource().equals(this.sliceSlider)) {
            this.vc.setTexCoord(this.sliceSlider.getValue());
        } else if (ce.getSource().equals(this.leftPanel)) {
            this.vc.setRendering(this.leftPanel.getSelectedIndex());
            System.out.println("state changed... ");
        } else if (ce.getSource().equals(stepSizeSlider)) {
            RayCasting.setStepSize(stepSizeSlider.getValue());
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (me.isControlDown()) {
            this.vc.rotateObject(me.getX(), me.getY());
        }
        if (me.isShiftDown()) {
            this.vc.translateObject(me.getX(), me.getY());
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        this.vc.zoomObject(mwe.getWheelRotation());
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == 38) {
            this.vc.zoomObject(1);
        } else if (ke.getKeyCode() == 40) {
            this.vc.zoomObject(-1);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }
}

