/*
 * Decompiled with CFR 0.152.
 */
package visualize;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.nio.FloatBuffer;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import visualize.ColorHist;
import visualize.LineDrawPanel;
import visualize.RayCasting;

public class GradientColorPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 5602858377933611827L;
    private static LinkedList<ColorHist> colorPoints;
    private static int colorRectHeight;
    private static int colorRectWidth;
    private static int colorRectTop;
    private static int tolerance;
    private static int offSet;
    private static ColorHist selectedColorHist;
    private ActionListener listener;
    private boolean colorPointsChanged;

    static {
        colorRectHeight = 8;
        colorRectWidth = 8;
        colorRectTop = 14;
        tolerance = 5;
        offSet = 3;
    }

    public GradientColorPanel() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        ColorHist c1 = new ColorHist(0, Color.BLACK);
        ColorHist c2 = new ColorHist(255, Color.WHITE);
        colorPoints = new LinkedList();
        colorPoints.add(c1);
        colorPoints.add(c2);
        this.colorPointsChanged = true;
    }

    public void init() {
        colorPoints.clear();
        ColorHist c1 = new ColorHist(0, Color.BLACK);
        ColorHist c2 = new ColorHist(255, Color.WHITE);
        colorPoints.add(c1);
        colorPoints.add(c2);
        selectedColorHist = null;
        this.colorPointsChanged = true;
        this.repaint();
        this.tellListenerNoSelection();
    }

    public LinkedList<ColorHist> getColorPoints() {
        return colorPoints;
    }

    public void FTOpened() {
        this.colorPointsChanged = true;
        this.repaint();
        this.tellListenerNoSelection();
    }

    public void addActionListener(ActionListener listener) {
        this.listener = listener;
    }

    public void tellListenerSelectionChanged() {
        ActionEvent event = new ActionEvent(this, 23, "gradient selection changed");
        this.listener.actionPerformed(event);
    }

    public void tellListenerNoSelection() {
        ActionEvent event = new ActionEvent(this, 23, "gradient deselected");
        this.listener.actionPerformed(event);
    }

    private static Color[] getInterpolatedColorHist() {
        Color[] cHist = new Color[1024];
        int curPoint = 1;
        ColorHist p1 = colorPoints.getFirst();
        ColorHist p2 = colorPoints.get(curPoint);
        float pointIdx = (float)p2.getGrayValue() / 255.0f;
        int i = 0;
        while (i < cHist.length) {
            float normIdx = (float)i / ((float)cHist.length - 1.0f);
            if (normIdx > pointIdx) {
                p1 = p2;
                p2 = colorPoints.get(++curPoint);
                pointIdx = (float)p2.getGrayValue() / 255.0f;
            }
            cHist[i] = GradientColorPanel.interpolatePoint(p1, p2, normIdx);
            ++i;
        }
        return cHist;
    }

    private static Color interpolatePoint(ColorHist p1, ColorHist p2, float normIdx) {
        float normGrayP1 = (float)p1.getGrayValue() / 255.0f;
        float normGrayP2 = (float)p2.getGrayValue() / 255.0f;
        float weight = (normIdx - normGrayP1) / (normGrayP2 - normGrayP1);
        int red = Math.round((float)p1.getColor().getRed() * (1.0f - weight) + (float)p2.getColor().getRed() * weight);
        int green = Math.round((float)p1.getColor().getGreen() * (1.0f - weight) + (float)p2.getColor().getGreen() * weight);
        int blue = Math.round((float)p1.getColor().getBlue() * (1.0f - weight) + (float)p2.getColor().getBlue() * weight);
        return new Color(red, green, blue);
    }

    private int convertPoint(int x) {
        return Math.round((x - offSet) * 256 / (this.getWidth() - 2 * offSet));
    }

    private int convertColorHist(ColorHist colorHist) {
        return Math.round((this.getWidth() - 2 * offSet) * colorHist.getGrayValue() / 256) + offSet;
    }

    private ColorHist getNearestColorHist(Point point) {
        ColorHist nearestColorHist = null;
        int posX = this.convertPoint(point.x);
        int posY = point.y;
        int i = 0;
        while (i < colorPoints.size()) {
            ColorHist colorHist = colorPoints.get(i);
            if (colorHist.getGrayValue() + tolerance > posX & colorHist.getGrayValue() - tolerance < posX & 10 < posY & this.getHeight() > posY) {
                if (nearestColorHist == null) {
                    nearestColorHist = colorHist;
                } else if (Math.abs(nearestColorHist.getGrayValue() - posX) > Math.abs(colorHist.getGrayValue() - posX)) {
                    nearestColorHist = colorHist;
                }
            }
            ++i;
        }
        return nearestColorHist;
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle colorRect;
        GeneralPath path;
        Graphics2D graphics = (Graphics2D)g;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (colorPoints.size() < 2) {
            return;
        }
        ColorHist lastColorHist = colorPoints.getFirst();
        ColorHist colorHist = null;
        int xValue = 0;
        int i = 1;
        while (i < colorPoints.size()) {
            colorHist = colorPoints.get(i);
            xValue = this.convertColorHist(colorHist);
            int lastXValue = this.convertColorHist(lastColorHist);
            Rectangle rect = i == 1 ? new Rectangle(lastXValue - 5, 0, xValue + 5, 10) : new Rectangle(lastXValue, 0, xValue, 10);
            GradientPaint gp = new GradientPaint(lastXValue, 1.0f, lastColorHist.getColor(), xValue, 1.0f, colorHist.getColor());
            graphics.setPaint(gp);
            graphics.fill(rect);
            graphics.setColor(Color.BLACK);
            graphics.drawRect(lastXValue - colorRectWidth / 2, colorRectTop, colorRectWidth, colorRectHeight);
            path = new GeneralPath();
            path.moveTo(lastXValue - colorRectWidth / 2, colorRectTop);
            path.lineTo(lastXValue, colorRectTop - colorRectWidth / 2);
            path.lineTo(lastXValue + colorRectWidth / 2, colorRectTop);
            graphics.draw(path);
            colorRect = new Rectangle(lastXValue - colorRectWidth / 2 + 1, colorRectTop + 1, colorRectWidth - 1, colorRectHeight - 1);
            graphics.setPaint(lastColorHist.getColor());
            graphics.fill(colorRect);
            if (lastColorHist == selectedColorHist) {
                graphics.setColor(Color.BLACK);
                graphics.fill(path);
            }
            lastColorHist = colorHist;
            ++i;
        }
        graphics.setColor(Color.BLACK);
        graphics.drawRect(xValue - colorRectWidth / 2, colorRectTop, colorRectWidth, colorRectHeight);
        path = new GeneralPath();
        path.moveTo(xValue - colorRectWidth / 2, colorRectTop);
        path.lineTo(xValue, colorRectTop - colorRectWidth / 2);
        path.lineTo(xValue + colorRectWidth / 2, colorRectTop);
        graphics.draw(path);
        colorRect = new Rectangle(xValue - colorRectWidth / 2 + 1, colorRectTop + 1, colorRectWidth - 1, colorRectHeight - 1);
        graphics.setPaint(colorHist.getColor());
        graphics.fill(colorRect);
        if (colorHist == selectedColorHist) {
            graphics.setColor(Color.BLACK);
            graphics.fill(path);
        }
        if (this.colorPointsChanged) {
            RayCasting.setTransferFunctionChanged(true);
            this.colorPointsChanged = false;
        }
        if (this.colorPointsChanged) {
            RayCasting.setTransferFunctionChanged(true);
            this.colorPointsChanged = false;
        }
    }

    public int getSelectedGrayValue() {
        return selectedColorHist.getGrayValue();
    }

    public int getSelectedRed() {
        return selectedColorHist.getColor().getRed();
    }

    public int getSelectedGreen() {
        return selectedColorHist.getColor().getGreen();
    }

    public int getSelectedBlue() {
        return selectedColorHist.getColor().getBlue();
    }

    private int getColorValue(String colorValeStr) {
        int colorValue;
        block3: {
            try {
                colorValue = Integer.parseInt(colorValeStr);
                if (colorValue >= 0 && colorValue <= 255) break block3;
                JOptionPane.showMessageDialog(null, "Color-Values must be in the ranges from 0 to 255", "Error", 0);
                return -1;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "You have entered a non-integer value in a color textfield, which only allows integer values.", "Error", 0);
                return -1;
            }
        }
        return colorValue;
    }

    public void setSelectedColorHist(String grayValueStr, String redStr, String greenStr, String blueStr) {
        int grayValue = 0;
        int green = 0;
        int red = 0;
        int blue = 0;
        try {
            grayValue = Integer.parseInt(grayValueStr);
            if (grayValue < 0 || grayValue > 255) {
                JOptionPane.showMessageDialog(null, "Grayvalues must be in the ranges from 0 to 255", "Error", 0);
                grayValue = -1;
            } else if (selectedColorHist == colorPoints.getFirst() & grayValue != 0 | selectedColorHist == colorPoints.getLast() & grayValue != 255) {
                JOptionPane.showMessageDialog(null, "The grayvalues of the first and the last gradient-points can't be changed.", "Error", 0);
                grayValue = -1;
            } else {
                int i = 0;
                while (i < colorPoints.size()) {
                    if (colorPoints.get(i).getGrayValue() == grayValue & colorPoints.get(i) != selectedColorHist) {
                        JOptionPane.showMessageDialog(null, "There is already a gradient-point existing with this grayvalue. Please enter another grayValue.", "Error", 0);
                        grayValue = -1;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "You have entered a non-integer value in the grayvalue textfield, which only allows integer values.", "Error", 0);
            grayValue = -1;
        }
        if (grayValue != -1 && (red = this.getColorValue(redStr)) != -1 && (green = this.getColorValue(greenStr)) != -1 && (blue = this.getColorValue(blueStr)) != -1) {
            selectedColorHist.setGrayValue(grayValue);
            selectedColorHist.setColor(new Color(red, green, blue));
            Collections.sort(colorPoints);
            this.colorPointsChanged = true;
            this.repaint();
            return;
        }
        this.tellListenerSelectionChanged();
    }

    public void deleteSelectedColorHist() {
        if (selectedColorHist == colorPoints.getFirst() || selectedColorHist == colorPoints.getLast()) {
            JOptionPane.showMessageDialog(null, "The first and the last gradient-points can't be deleted.", "Error", 0);
        } else {
            colorPoints.remove(selectedColorHist);
            selectedColorHist = null;
            this.tellListenerNoSelection();
            this.colorPointsChanged = true;
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        ColorHist lastSelectedColorHist = selectedColorHist;
        if (me.isControlDown()) {
            int mousePos = this.convertPoint(me.getPoint().x);
            ColorHist chLeft = null;
            ColorHist chRight = null;
            int i = 0;
            while (i < colorPoints.size()) {
                if (colorPoints.get(i).getGrayValue() == mousePos) {
                    JOptionPane.showMessageDialog(null, "At this grayvalue there is an gradient-point already existing. You can't add a point at this grayvalue.", "Error", 0);
                    return;
                }
                chRight = colorPoints.get(i);
                if (chRight.getGrayValue() > mousePos) {
                    chLeft = colorPoints.get(i - 1);
                    break;
                }
                ++i;
            }
            Color leftColor = chLeft.getColor();
            Color rightColor = chRight.getColor();
            int distance = chRight.getGrayValue() - chLeft.getGrayValue();
            int pos = mousePos - chLeft.getGrayValue();
            double scaleRight = pos * 100 / distance;
            double scaleLeft = 100.0 - scaleRight;
            int colorR = (int)Math.round((double)leftColor.getRed() * scaleLeft / 100.0) + (int)Math.round((double)rightColor.getRed() * scaleRight / 100.0);
            int colorG = (int)Math.round((double)leftColor.getGreen() * scaleLeft / 100.0) + (int)Math.round((double)rightColor.getGreen() * scaleRight / 100.0);
            int colorB = (int)Math.round((double)leftColor.getBlue() * scaleLeft / 100.0) + (int)Math.round((double)rightColor.getBlue() * scaleRight / 100.0);
            ColorHist colorHist = new ColorHist(this.convertPoint(me.getPoint().x), new Color(colorR, colorG, colorB));
            colorPoints.add(colorHist);
            Collections.sort(colorPoints);
            selectedColorHist = colorHist;
            this.colorPointsChanged = true;
        } else {
            Color c;
            selectedColorHist = this.getNearestColorHist(me.getPoint());
            if (me.getClickCount() == 2 & selectedColorHist != null && (c = JColorChooser.showDialog(new JFrame(), "Select color...", selectedColorHist.getColor())) != null) {
                selectedColorHist.setColor(c);
                this.colorPointsChanged = true;
                this.tellListenerSelectionChanged();
            }
        }
        if (selectedColorHist != lastSelectedColorHist) {
            if (selectedColorHist == null) {
                this.tellListenerNoSelection();
            } else {
                this.tellListenerSelectionChanged();
            }
        }
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int pos = this.convertPoint(e.getPoint().x);
        int index = colorPoints.indexOf(selectedColorHist);
        if (selectedColorHist != null & selectedColorHist != colorPoints.getFirst() & selectedColorHist != colorPoints.getLast()) {
            if (pos <= colorPoints.get(index - 1).getGrayValue() + 1) {
                pos = colorPoints.get(index - 1).getGrayValue() + 1;
            } else if (pos >= colorPoints.get(index + 1).getGrayValue() - 1) {
                pos = colorPoints.get(index + 1).getGrayValue() - 1;
            }
            selectedColorHist.setGrayValue(pos);
            this.colorPointsChanged = true;
            this.repaint();
            this.tellListenerSelectionChanged();
        }
    }

    public void mouseDragMoved(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public static FloatBuffer getTransferFunction() {
        Color[] cHist = GradientColorPanel.getInterpolatedColorHist();
        System.out.println("t_function length: " + cHist.length);
        float[] opacity = LineDrawPanel.getInterpolatedOpacity();
        float[] transfer = new float[cHist.length * 4];
        int i = 0;
        while (i < cHist.length) {
            transfer[i * 4] = (float)cHist[i].getRed() / 255.0f;
            transfer[i * 4 + 1] = (float)cHist[i].getGreen() / 255.0f;
            transfer[i * 4 + 2] = (float)cHist[i].getBlue() / 255.0f;
            transfer[i * 4 + 3] = opacity[i];
            ++i;
        }
        return FloatBuffer.wrap(transfer);
    }
}

