// 
//
// Fragment Shader to render ArrowPlots
//
#include "Renderer.glsl"

uniform sampler2D texArrow;
uniform sampler2D texFlow;
uniform sampler2D texGrid;
uniform sampler1D texTransfer;
uniform float stepX;
uniform float stepY;
uniform vec2 vecflow;
uniform bool bfixedSize;

uniform int iSizeParam;
uniform int iColorParam;

uniform bool bdebug;
uniform float iangel;

void main(){
  float pi  = 3.14159265358;
  float tpi = 6.28318530717;

  float leny =1.0;
  float lenx =1.0;
  
  
  vec4 flow = getValue(vecflow.xy, texture2D(texGrid, vecflow.xy).xy, texGrid, texFlow,1.0/stepX, 1.0/stepY);
 // vec4 flow = vec4(texture2D(texFlow, texture2D(texGrid, vecflow.xy).xy));	
  //vec4 flow = vec4(texture2D(texFlow, vecflow.xy));
  
  if( all (equal (flow.xy, vec2(0.0,0.0))) )
		discard;
	
  
  float angle = atan( sin(-asin(flow.x)), cos(-acos(flow.y)));		
  float sina = sin((angle));
  float cosa = cos((angle));
  //mat2 rotX = mat2(cosa,  -sina, sina,   cosa);	
  //mat2 rotX = mat2(1.0,  0.0, 0.0,   1.0);	
  //mat2 scX = mat2( lenx ,  0.0, 0.0, leny);
  //vec2 tt   = (rotX * scX) * vec2(gl_TexCoord[0].x -0.5,  gl_TexCoord[0].y -0.5);
 //   vec2 coord = vec2(tt.x + 0.5,tt.y + 0.5);
 
 if(bdebug){
	sina = sin(radians(iangel));		
	cosa = cos(radians(iangel));
	angle = radians(iangel);
 }
 //here we set the size
 if(!bfixedSize){	
   lenx = 1.0;
   if(iSizeParam == 0)leny = (1.0-clamp(flow.a,0.0,1.0))+0.5;
   else               leny = smoothstep (0.0, tpi, angle)+(0.5 *(1.0-smoothstep (0.0, tpi, angle)));
  }else{
   lenx = 1.0;
   leny = 1.0;
  }
  
   mat3 rotX  = mat3(cosa,-sina, 0.0,
                     sina, cosa, 0.0,
                      0.0,  0.0, 1.0);	
                      
   mat3 scX   = mat3( lenx,      0.0, 0.0,
                           0.0, leny, 0.0,
                           0.0,      0.0, 1.0); 
   
   mat3 trans = mat3(  1.0, 0.0, 0.5,
                       0.0, 1.0, 0.5,
                       0.0, 0.0,  1.0);                    
 
    mat3 transinv = mat3(  1.0, 0.0, -0.5,
                           0.0, 1.0, -0.5,
                           0.0, 0.0, 1.0);
                        		     
  mat3 mt   = ((trans * scX * rotX * transinv));
  
  vec3 tt   =  mt* vec3(gl_TexCoord[0].x-0.5,  gl_TexCoord[0].y-0.5,0.0);
  
  vec2 coord = vec2(tt.x+0.5,tt.y+0.5);
  
  
  ///////////////////////////////////////////////////
	//alpha map	
	if(all(greaterThan(texture2D(texArrow,coord.st).rgb, vec3(0.1,0.1,0.1))))
		discard;	
	
	
	 float co;
	 if(iColorParam==0)
		co = flow.a;
	 else
		co = (smoothstep (-tpi, tpi, angle));

	    
	 vec4 color = texture1D(texTransfer, co);
	 gl_FragColor = vec4(color.rgb,getAlpha(gl_Color.a,color.a));
	 
		//gl_FragColor   = vec4( (texture1D(texTransfer, co)).rgb,gl_Color.a);	
		//if(flow.a <= 0.45)
		//	gl_FragColor = vec4(1.0,0.0,0.0,1.0);
		//else if(flow.a <=0.5)
		//	gl_FragColor = vec4(0.0,1.0,0.0,1.0);
		//else if(flow.a <=0.7)
		//	gl_FragColor = vec4(0.0,1.0,1.0,1.0);			
		//else if(flow.a <=1.0)	
		//	gl_FragColor = vec4(0.0,0.0,1.0,1.0);
}
