
vec4 interpolate(vec4 param0, vec4 param1, float coef){
	return (coef * param0) + ((1.0-coef) * param1);
}
float getAlpha(float globalAlpha, float localAlpha){


return globalAlpha*localAlpha;
}


vec4 getValue(vec2 currCoord, vec2 gridCoord, sampler2D texGrid, sampler2D texData, float stepX, float stepY){

    // float step = 0.002;//1.0/255.0;//0.000003921568627450980392156862745098;///---> 1.0/255.0; 

	//calculate coef
	float coefx	= ( (currCoord.x - texture2D(texGrid, gridCoord).x)/
                  (texture2D(texGrid, vec2(gridCoord.x+stepX,gridCoord.y)).x - texture2D(texGrid, gridCoord).x) 
	);
				  
	float coefy	= ( (currCoord.y - texture2D(texGrid, gridCoord).y)/
                   (texture2D(texGrid, vec2(gridCoord.x,gridCoord.y+stepY)).y - texture2D(texGrid, gridCoord).y) 
	);
	
	//calculate coef
	coefx	= ( (currCoord.x - texture2D(texGrid, gridCoord).x)/
                  (texture2D(texGrid, vec2(gridCoord.x+stepX,gridCoord.y)).x - currCoord.x) 
	);
				  
	coefy	= ( (currCoord.y - texture2D(texGrid, gridCoord).y)/
                   (texture2D(texGrid, vec2(gridCoord.x,gridCoord.y+stepY)).y - currCoord.y) 
	);	
	//coefy = 0.5;
	//coefx = 0.5;
	//get theValue
	vec4 value = interpolate(
				interpolate(
					texture2D(texData, gridCoord),
					texture2D(texData, vec2(gridCoord.x+stepX,gridCoord.y  )),
					smoothstep (0.0, 1.0, coefx)
					//coefx
				), 
				interpolate(
				    texture2D(texData, vec2(gridCoord.x,gridCoord.y+stepY)),
				    texture2D(texData, vec2(gridCoord.x+stepX,gridCoord.y+stepY)),
				    smoothstep (0.0, 1.0, coefx)
				    //coefx
				),
				smoothstep (0.0, 1.0, coefy)
				//coefy
			);






return value;
}
