//RENDERER RAYCASTER FRAGMENT
uniform sampler2D texTransfer;
uniform sampler3D texIntensity;
uniform sampler2D texEntryPoint;
uniform sampler2D texExitPoint;
uniform float steps;
varying mat4 myModelView;

void main(){

    float dz = 0.005;

	vec4 light = vec4(0.0, 0.0, 10.0, 1.0);
	// light = light * myModelView;	// transform lightvec
	vec3 eye   = vec3( 0.0, 0.0, -2.5);	
	vec3 half  = normalize(eye + light.xyz);
	float NdotL;
	float NdotH;
		
	vec4 intensity;			//intensity of 3D texture and gradient
	vec4 transferred ;		//transferred color in 2D Transferfunction
	vec4 ResultColor ;		// the resulting color, we send it to gl_FragColor
	
	vec3 EntryPoint = texture2D(texEntryPoint, gl_TexCoord[0].xy).xyz; //entry Point were we start rendering
	vec3 ExitPoint  = texture2D(texExitPoint , gl_TexCoord[0].xy).xyz; //exit Point were we stop
	
	if (length(ExitPoint-EntryPoint) <= 0.0)
		discard;	
			
	vec4 RayPosition  = vec4(EntryPoint.xyz,0.0);
	vec4 RayIncrement = vec4( (ExitPoint-EntryPoint).xyz/steps,1.0/steps);	
	
	float ambI = 0.4;
	float diffI = 0.2;
	float specI = 0.0;
	float shin = 40.0;
	vec3 kA;
	vec3 kD;
	vec3 kS;
	float diff;
	float spec;		

	do
	{		
		intensity    = texture3D(texIntensity, RayPosition.xyz );
		transferred  = texture2D(texTransfer, vec2(intensity.a,0));
		float len = length(intensity.xyz);
			
		//transferred.a *= intensity.a;		
		vec4 TempColor;	
		TempColor.rgb = transferred.a * transferred.rgb;
		TempColor.a   = transferred.a;
					
		kA = TempColor.rgb * ambI;
		kD = TempColor.rgb * diffI;
		kS = vec3(1.0,1.0,1.0) * specI;
								
	    diff = 0.0;
	    if(transferred.a > 0.0 && len > 0.1){
			intensity.xyz = normalize(intensity.xyz);	
			NdotL = max(dot((intensity.xyz), (light.xyz)), 0.0);			
			if(NdotL > 0.0){						
				diff = NdotL;	
			}	
		}
		
		spec = 0.0;
		if(transferred.a > 0.0 && len > 0.1){
			NdotH = max(dot(intensity.xyz, half.xyz),0.0);
			if(NdotH > 0.0){			    
			    spec = pow(NdotH, shin);				    									
			    if(spec > 1.0)
					spec = 1.0;
			}
		}
		
		TempColor = vec4(kA,1.0) + vec4(kD,1.0) * diff + vec4(kS,1.0) * spec;	
		
		if(TempColor.a > 1.0){
			TempColor.a = 1.0;																			
		}
		
		TempColor.r *= TempColor.a;
		TempColor.g *= TempColor.a;
		TempColor.b *= TempColor.a;
		
		ResultColor.rgb += (1.0 - ResultColor.a) * TempColor.rgb;
		ResultColor.a += (1.0 - ResultColor.a) * transferred.a;
						
		RayPosition += RayIncrement;				
			
	} while((RayPosition.w <= 1.0) && (ResultColor.a < 1.0));
	
	gl_FragColor = ResultColor;	
	//gl_FragColor = vec4(EntryPoint.xyz,1.0);	
}	